package netmatch.qtool;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PNodeFilter;

import java.awt.*;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Iterator;

import netmatch.piccolox.PSelectionEventHandler;

public class QSelectHandler extends PSelectionEventHandler {
  private QToolFrame frame;

  public QSelectHandler(PNode pNode, PNode pNodel, QToolFrame frame) {
    super(pNode, pNodel);
    this.frame = frame;
  }

  public void decorateSelectedNode(PNode node) {
    node.setPaint(QNode.SELECTED_NODE_COLOR);
    super.decorateSelectedNode(node);
  }

  public void undecorateSelectedNode(PNode node) {
    node.setPaint(QNode.NODE_COLOR);
    super.undecorateSelectedNode(node);
  }

  public void mouseMoved(PInputEvent event) {
    super.mouseMoved(event);
    showInfo(event);
  }

  private void showInfo(PInputEvent event) {
    QElement elem;
    if(event.getPickedNode() instanceof QText)
      elem = ((QText) event.getPickedNode()).getOwner();
    else if(event.getPickedNode() instanceof QElement)
      elem = (QElement) event.getPickedNode();
    else {
      frame.infoArea.setText("");
      return;
    }
    frame.infoArea.setText(elem.getInfo());
  }

  public void mouseClicked(PInputEvent event) {
    super.mouseClicked(event);
    if(event.isRightMouseButton()) {
      showPopup(event);
    }
  }

  private void showPopup(PInputEvent event) {
    Point2D pos = event.getPosition();
    int x = (int) pos.getX();
    int y = (int) pos.getY();

    QElement popupElement;

    if(event.getPickedNode() instanceof QText)
      popupElement = ((QText) event.getPickedNode()).getOwner();
    else if(!(event.getPickedNode() instanceof QElement))
      return;
    else
      popupElement = (QElement) event.getPickedNode();

    frame.popup.show((Component) event.getComponent(), x, y, popupElement);
  }


  protected void drag(PInputEvent e) {
    super.drag(e);
    Collection selectedNodes = getSelectionReference();
    Iterator it = selectedNodes.iterator();
    while(it.hasNext()) {
      PNode node = (PNode) it.next();
      if(node instanceof QNode)
        ((QNode) node).update();
    }
  }

  protected void startDrag(PInputEvent e) {
    super.startDrag(e);
  }

  public void select(PNode node) {
    //System.out.println("selecting.. " + node);
    if(node instanceof QText)
      super.select(((QText) node).getOwner());
    else
      super.select(node);
  }


  protected PNodeFilter createNodeFilter(PBounds bounds) {
    return new MyBoundsFilter(bounds);
  }

  protected class MyBoundsFilter extends PSelectionEventHandler.BoundsFilter {

    protected MyBoundsFilter(PBounds bounds) {
      super(bounds);
    }

    public boolean accept(PNode node) {
      if(node instanceof QText)
        return false;
      return super.accept(node);
    }

    public boolean acceptChildrenOf(PNode node) {
      if(node instanceof QText)
        return false;
      return super.acceptChildrenOf(node);
    }

    public boolean isCameraLayer(PNode node) {
      return super.isCameraLayer(node);
    }
  }


}




