package netmatch.qtool;

import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.nodes.PPath;

import java.awt.*;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;

import netmatch.piccolox.PFixedWidthStroke;

public class QLoop extends PPath implements QElement {
  private static final Color LOOP_COLOR = new Color(33, 33, 119);
  private static final PFixedWidthStroke eStroke = new PFixedWidthStroke(2);
  private QNode owner;
  private String attr = "?";
  private String id;
  private int valence = 0;

  public QLoop(QNode owner, String id) {
    super(new Ellipse2D.Float(0, 0, 20, 20));
    this.id = id;
    this.owner = owner;
    setStroke(eStroke);
    setStrokePaint(LOOP_COLOR);
    update();
  }

  public void delete(PLayer nodeLayer, PLayer edgeLayer) {
    owner.removeLoop(this);
    edgeLayer.removeChild(this);
  }

  public String getInfo() {
    return "Edge\n" + "Id: " + id + "\n" + "Attribute: " + attr + "\n" + "Parent Id: " + getOwner().getId() + "\n";
  }

  public String getId() {
    return id;
  }

  public void update() {
    Point2D center = owner.getFullBoundsReference().getCenter2D();
    double width = owner.getFullBoundsReference().getWidth() * (0.7 + valence * 0.15);
    double height = owner.getFullBoundsReference().getHeight() * (0.7 + valence * 0.15);
    setWidth(width);
    setHeight(height);
    centerBoundsOnPoint(center.getX(), center.getY() - height / 2);
  }

  public QNode getOwner() {
    return owner;
  }

  public void setAttr(String attr) {
    this.attr = attr;
  }

  public String getAttr() {
    return attr;
  }

  public void setValence(int newValence) {
    valence = newValence;
  }

  public int getValence() {
    return valence;
  }

}