package netmatch.qtool;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;

import java.awt.geom.Point2D;
import java.awt.*;

public class QCreateEdgeHandler extends PBasicInputEventHandler {

  private QNode nodeFrom = null;
  private QEdge edge = null;
  private QToolFrame frame;

  public QCreateEdgeHandler(QToolFrame frame) {
    this.frame = frame;
  }

  private void showPopup(PInputEvent event) {
    Point2D pos = event.getPosition();
    int x = (int) pos.getX();
    int y = (int) pos.getY();

    QElement popupElement;

    if(event.getPickedNode() instanceof QText)
      popupElement = ((QText) event.getPickedNode()).getOwner();
    else if(!(event.getPickedNode() instanceof QElement))
      return;
    else
      popupElement = (QElement) event.getPickedNode();

    frame.popup.show((Component) event.getComponent(), x, y, popupElement);
  }

  private void showInfo(PInputEvent event) {
    QElement elem;
    if(event.getPickedNode() instanceof QText)
      elem = ((QText) event.getPickedNode()).getOwner();
    else if(event.getPickedNode() instanceof QElement)
      elem = (QElement) event.getPickedNode();
    else {
      frame.infoArea.setText("");
      return;
    }
    frame.infoArea.setText(elem.getInfo());
  }

  public void mouseClicked(PInputEvent e) {
    if(e.isRightMouseButton() && nodeFrom == null) {
      showPopup(e);
    }

    if(!e.isLeftMouseButton())
      return;

    PCamera pCamera = ((PCanvas) (e.getComponent())).getCamera();
    PLayer edgeLayer = pCamera.getLayer(0);
    PLayer nodeLayer = pCamera.getLayer(1);

    if(!(e.getPickedNode() instanceof QNode || e.getPickedNode() instanceof QText)) {
      nodeFrom = null;
      if(edge != null)
        edge.delete(nodeLayer, edgeLayer);
      edge = null;
      return;
    }
    if(nodeFrom == null) {// source node
      if(e.getPickedNode() instanceof QText)
        nodeFrom = ((QText) e.getPickedNode()).getOwner();
      else
        nodeFrom = (QNode) e.getPickedNode();
      edge = new QEdge("e" + Network.edgeCount++);
      edge.setSource(nodeFrom);
      edgeLayer.addChild(edge);
      //drawEdge();
    }
    else {// target node
      QNode nodeTo;
      if(e.getPickedNode() instanceof QText)
        nodeTo = ((QText) e.getPickedNode()).getOwner();
      else
        nodeTo = (QNode) e.getPickedNode();
      edge.setTarget(nodeTo);
      //edge.update();
      nodeFrom.addEdge(edge);
      nodeTo.addEdge(edge);
      nodeFrom.update();
      nodeFrom = null;
      edge = null;
      frame.isModif = true;
      frame.setTitleModif();
      Network.eCount++;
      frame.updateStatus();
    }

  }

  public void mouseMoved(PInputEvent event) {
    if(edge != null) {
      edge.drawTo(event.getPosition());
    }
    if(event.getPickedNode() instanceof QEdge && event.getPickedNode() == edge)
      return;
    showInfo(event);
  }


}
