package nanomunchers.graph;
import java.util.*;
import java.awt.*;
/*
 * Created on Oct 24, 2003
 * 
 */

public class Graph {

	Vector n = new Vector();  // all nodes
	Vector s = new Vector();  //sets of nodes
	//Vector e = new Vector();

	//	Node[] nodes = null;
	//NodeSet[] sets = null;

	public Graph() {
		super();
		// TODO Auto-generated constructor stub
	}

	public static Node[] toArray(Vector v) {
		Node[] nodes = new Node[v.size()];
		for (int i = 0, c = v.size(); i < c; i++) {
			nodes[i] = (Node) v.elementAt(i);
		}
		return nodes;
	}

	public void clear() {
		n.removeAllElements();
	}

	public void clearBots() {

		for (int i = 0; i < n.size(); i++) {
			getNode(i).setBot(null);
		}
	}

	public void clearNodes() {
		s.removeAllElements();
	}

	public void initEdges() {

		for (int i = 0; i < n.size(); i++) {
			getNode(i).init();
		}
	}

	public int getNodeSetSize() {
		return s.size(); // sets.length;
	}

	public NodeSet getNodeSet(int i) {
		return (NodeSet) s.elementAt(i); // sets[s];
	}

	public void addSet(NodeSet set) {
		s.addElement(set);
	}

	public void unmarkNodes(Node[] nodes) {

		for (int i = 0; i < nodes.length; i++) {
			nodes[i].unMark();
		}
	}

	public int liveCount() {
		int count = 0;
		for (int i = 0; i < getNodeSetSize(); i++) {
			NodeSet set = getNodeSet(i);
			count += set.liveCount();
		}
		return count;
	}

	public int nodesLeft() {
		int count = 0;
		for (int i = 0; i < n.size(); i++) {
			if (!getNode(i).marked) {
				count++;
			}
		}
		return count;
	}

	public void unmarkNodes(Vector nodes) {

		for (int i = 0; i < nodes.size(); i++) {
			((Node) nodes.elementAt(i)).unMark();
		}
	}
	/**
	 * Performs makeSets on this graph
	 * 
	 * @return Islands of nodes
	 */
	public NodeSet[] makeSets(){
	    return makeSets(n);
	}
	// walks through a set of nodes and breaks them up
	// into islands of connected nodes.

	public NodeSet[] makeSets(Vector n) {

		Vector newSets = new Vector();

		for (int i = 0; i < n.size(); i++) {

			Node node = (Node) n.elementAt(i);

			if (!node.marked) {

				NodeSet set = new NodeSet();
				newSets.addElement(set);
				set.setColor(
					new Color(
						newSets.size() * 50 % 250,
						newSets.size() * 5 % 250,
						newSets.size() * 157 % 250));
				
				node.mark(null);
				set.addNode(node);
				walkNode(node, set, n);
			}
		}
	
		unmarkNodes(n);  // return intial condition
	
	    // convert to array, this could be done with .toArray() method
		NodeSet[] sets = new NodeSet[newSets.size()];
		for (int i = 0; i < newSets.size(); i++) {
			sets[i] = (NodeSet) newSets.elementAt(i);
		}
		return sets;
	}

    // takes a starting node and adds it to a nodeset
    // then recursively walks through the edges
   
	void walkNode(Node n, NodeSet set, Vector b) {
		for (int i = 0, c = NodeSet.MAX_EDGES; i < c; i++) {

			Node edge = n.getEdge(i);
			if (edge != null) {
				if (!edge.marked && b.contains(edge)) {
					edge.mark(null);
					set.addNode(edge);
					walkNode(edge, set, b);
				}
			}

		}
	}

	public void addNode(int id, int x, int y) {
		n.addElement(new Node(id, x, y));
	}

	public void addNode(Node node) {
		n.addElement(node);
	}

	public Node getNode(int i) {
		if (i < n.size()) {
			return (Node) n.elementAt(i); // sets[s];
		}
		return null;

	}

	public Node getNodeId(int id) {
		for (int i = 0; i < getNodeSize(); i++) {
			Node n = getNode(i);
			if (n.id == id) {
				return n;
			}
		}
		return null;
	}

	public void addEdge(int x, int y) {
		getNodeId(x).addEdge(getNodeId(y));
		getNodeId(y).addEdge(getNodeId(x));
	}

	public int getNodeSize() {
		return n.size();
	}

	/**
	 * Ripped from VoodooNano
	 * 
	 * @param width of the grid
	 * @param height of the grid
	 */
	public void randomize(int width, int height){
	    Random r = new Random();
		NodeSet set = new NodeSet();
		int count = 0;
		Vector nodes = new Vector();
		Vector edges = new Vector();
		for (int w = 0; w < width; w++) {

			for (int h = 0; h < height; h++) {

				int ri = Math.abs(r.nextInt());
				//System.out.println ( ri + "  " + ri % 2);
				if (ri % 2 == 1) {

					Node n = new Node(count, w, h);
					count++;
					set.addNode(n);
					nodes.add(n);
				}
			}
		}

		for (int w = 0; w < (width - 1); w++) {

			for (int h = 0; h < height; h++) {

				Node n = set.getNode(w, h);
				Node n2 = set.getNode(w + 1, h);
				if (n != null && n2 != null && r.nextInt() % 5 < 4) {
					set.addEdge(n.getId(), n2.getId());
					this.addEdge(n.getId(), n2.getId());
				}
			}
		}

		for (int w = 0; w < width; w++) {

			for (int h = 0; h < (height -1); h++) {

				Node n = set.getNode(w, h);
				Node n2 = set.getNode(w, h + 1);
				if (n != null && n2 != null && r.nextInt() % 5 < 4) {
					set.addEdge(n.getId(), n2.getId());
					this.addEdge(n.getId(), n2.getId());
				}
			}
		}
		initEdges();
		NodeSet[] sets = makeSets();

		for (int i = 0; i < sets.length; i++) {
			addSet(sets[i]);
		}
	}
	
	public static void main(String[] args) {
	}

}
