package heurgame.ui;

import java.awt.Button;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

import heurgame.GameServer;
import heurgame.PlayerToken;
import heurgame.event.PlayerEvent;
import heurgame.event.PlayerListener;

/*
 * Created on Oct 12, 2004
 */


/**
 * @author David Kaplin
 *
 * Presents a screen that allows protocol independant choosing
 * of the order of connecting players and that of the local
 * players that are interfaced via HuClients
  */
public class WelcomeScreen implements PlayerListener{
    private GameServer gameServer;
    private Frame welcomeWindow = null;
    private Button startButton = null;
    private Button exitButton = null;
    private List connectedPlayers = new List();
    private Vector playerOrder = new Vector();

    /**
     * Constructs the WelcomeScreen builder
     * 
     * @param gs handle to the GameServer to get information
     * and access the general facade of the GameServer
     */
    public WelcomeScreen(GameServer gs){
        gameServer = gs;
    }
    /**
     * Returns the Welcome Screen if it was built.
     * 
     * @return null, if the screen was not built yet.
     */
    public Frame getBuiltWelcome(){
        return welcomeWindow;
    }
    /**
     * Produces the WelcomeScreen as an AWT Frame.
     * 
     * @param onStart Called by the Start Button
     * @param onExit  Called by the exit button or by closing the window
     * @return a complete AWT Frame ready for interaction
     */
    public Frame getWelcome(final Runnable onStart, final Runnable onExit){
        welcomeWindow = new Frame(gameServer.getGameName());
        welcomeWindow.addWindowListener(new WindowListener() {
            public void windowActivated(WindowEvent e) {
            }

            public void windowClosed(WindowEvent e) {
            	onExit.run();
            }

            public void windowDeactivated(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowOpened(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
                welcomeWindow.hide();
            }
        });

        final Button upButton = new Button("Up");
        final Button downButton = new Button("Down");
        
        Panel main = new Panel();
        GridBagConstraints layoutInfo= new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        
        layoutInfo.insets = new java.awt.Insets(2,2,2,2);
        layoutInfo.weightx = 1;
        layoutInfo.weighty = 1;
        layoutInfo.fill = GridBagConstraints.BOTH;
        layoutInfo.anchor = GridBagConstraints.CENTER;
        layoutInfo.gridwidth = GridBagConstraints.REMAINDER;
        main.setLayout(gridbag);
        Label welcome = new Label("Welcome to "+gameServer.getGameName());
        gridbag.setConstraints(welcome,layoutInfo);
        main.add(welcome);
        
        while(gameServer.isActive()==false){
            try {
                Thread.sleep(100);
                System.out.println("Trying server... "+gameServer.isActive());
                } catch (InterruptedException e){
                e.printStackTrace();
            }
        }
        
        Label server = new Label("Server now at: "+gameServer.getServerAddress());
        gridbag.setConstraints(server,layoutInfo);
        main.add(server);
        
        layoutInfo.gridheight = 3;
        layoutInfo.weightx = 3;
        layoutInfo.weighty = 3;
        layoutInfo.gridwidth = GridBagConstraints.RELATIVE;
        connectedPlayers = new List();
        gridbag.setConstraints(connectedPlayers,layoutInfo);
        main.add(connectedPlayers);
        
        layoutInfo.gridheight = 1;
        layoutInfo.weightx = 1;
        layoutInfo.weighty = 1;
        layoutInfo.fill = GridBagConstraints.NONE;
        layoutInfo.gridwidth = GridBagConstraints.REMAINDER;
        Button resetButton = new Button("Reset");
        resetButton.addActionListener(new ActionListener(){
           public void actionPerformed(ActionEvent e){
               Thread t = new Thread(){
                 public void run(){
                     gameServer.reset();
                 }
               };
               t.start();
           }
        });
        gridbag.setConstraints(resetButton,layoutInfo);
        main.add(resetButton);
        
        upButton.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e){
                int selIndex = connectedPlayers.getSelectedIndex();
                if (selIndex > 0){
                    String toRemove = connectedPlayers.getSelectedItem();
                    connectedPlayers.remove(selIndex);
                    connectedPlayers.add(toRemove,selIndex - 1);
                    PlayerToken remTok = (PlayerToken)playerOrder.remove(selIndex);
                    playerOrder.add(selIndex -1,remTok);
                }
            }
        });
        gridbag.setConstraints(upButton,layoutInfo);
        main.add(upButton);
        
        
        downButton.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e){
                int selIndex = connectedPlayers.getSelectedIndex();
                if (selIndex !=  -1 && selIndex < (connectedPlayers.getItemCount()-1)){
                    String toRemove = connectedPlayers.getSelectedItem();
                    connectedPlayers.remove(selIndex);
                    connectedPlayers.add(toRemove,selIndex + 1);
                    PlayerToken remTok = (PlayerToken)playerOrder.remove(selIndex);
                    playerOrder.add(selIndex +1,remTok);
                }
            }
        });
        gridbag.setConstraints(downButton,layoutInfo);
        main.add(downButton);
        
        Label name = new Label("Name");
        layoutInfo.gridwidth = 1;
        gridbag.setConstraints(name,layoutInfo);
        main.add(name);
        
      
        final TextField nameField = new TextField(40);
        final Button joinButton = new Button("Join");
        
        ActionListener huJoin = new ActionListener(){
            public void actionPerformed(ActionEvent e){
                Thread t = new Thread(){
                    public void run(){
                        if (nameField.getText().length()==0){
                            nameField.setText("Please enter a name here first");
                            nameField.selectAll();
                            nameField.requestFocusInWindow();
                            return;
                        }
                        nameField.setEnabled(false);
                        joinButton.setEnabled(false);
                        gameServer.makeHuClient(nameField.getText());
                        nameField.setText("");
                        nameField.setEnabled(true);
                        joinButton.setEnabled(true);
                        nameField.requestFocusInWindow();
                    }
                };
                t.start();
            }
          };
        layoutInfo.gridwidth = GridBagConstraints.RELATIVE;
        gridbag.setConstraints(nameField,layoutInfo);
        nameField.addActionListener(huJoin);
        main.add(nameField);
        
        
        layoutInfo.gridwidth = GridBagConstraints.REMAINDER;
        gridbag.setConstraints(joinButton,layoutInfo);
        joinButton.addActionListener(huJoin);
        main.add(joinButton);
        
        layoutInfo.gridwidth =GridBagConstraints.RELATIVE;
        layoutInfo.anchor =GridBagConstraints.WEST;
        exitButton = new Button("Exit");
        exitButton.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e){
                Thread t = new Thread(onExit);
                t.run();
            }
        });
        gridbag.setConstraints(exitButton,layoutInfo);
        main.add(exitButton);
        
//      Window has been build, just stich it up
        layoutInfo.gridwidth =GridBagConstraints.REMAINDER;
        layoutInfo.anchor =GridBagConstraints.EAST;
        startButton = new Button("Start");
        startButton.setEnabled(false);
        startButton.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e){
                PlayerToken[] out = new PlayerToken[playerOrder.size()];
                for(int i=0;i<out.length;i++){
                    out[i] = (PlayerToken)playerOrder.get(i);
                }
                gameServer.reorderPlayers(out);
                Thread t = new Thread(onStart);
                t.run();
            }
        });
        gridbag.setConstraints(startButton,layoutInfo);
        main.add(startButton);
        welcomeWindow.setLayout(new java.awt.BorderLayout());
        welcomeWindow.add(main,java.awt.BorderLayout.CENTER);
        
        return welcomeWindow;
    }
    
    /** 
     * @see heurgame.event.PlayerListener#playerJoined(heurgame.event.PlayerEvent)
     */
    public void playerJoined(PlayerEvent e) {
        // TODO Auto-generated method stub
        connectedPlayers.add(e.player.getName());
        playerOrder.add(e.player);
        if (connectedPlayers.getItemCount()<gameServer.getMinimumPlayers()){
            startButton.setEnabled(false);
        }else{
            startButton.setEnabled(true);
        }
    }
    /** 
     * @see heurgame.event.PlayerListener#playerLeft(heurgame.event.PlayerEvent)
     */
    public void playerLeft(PlayerEvent e) {
        // TODO Auto-generated method stub
        String[] ilist = connectedPlayers.getItems();
        String sought = e.player.getName();
        int tokill = -1;
        for(int i=0;i<ilist.length;i++){
            if (ilist[i].equals(sought)) {
                tokill = i;
                break;
            }
        }
        try {
        connectedPlayers.remove(e.player.getName());
        } catch (Exception illarg){
            //do nothing
        }
        playerOrder.remove(e.player);
        if (connectedPlayers.getItemCount()<gameServer.getMinimumPlayers()){
            startButton.setEnabled(false);
        }else{
            startButton.setEnabled(true);
        }
    }
    /** 
     * Not used
     * @see heurgame.event.PlayerListener#playerMoved(heurgame.event.PlayerEvent)
     */
    public void playerMoved(PlayerEvent e) { }
    /** 
     * Not used
     * @see heurgame.event.PlayerListener#playerStatusChanged(heurgame.event.PlayerEvent)
     */
    public void playerStatusChanged(PlayerEvent e) {}

    
}
