package nanomunchers.bot;

import java.awt.Point;

import nanomunchers.graph.KNode;

/*
 * Created on Oct 26, 2004
 */

/**
 * @author David Kaplin
 *  
 */
public class KNanoBot {
    public final static int UP = 4;

    public final static int LEFT = 3;

    public final static int DOWN = 2;

    public final static int RIGHT = 1;

    protected int nodesMunched;

    protected boolean alive;

    protected int cycle;
    protected int positionDelta;//Extra added to instruction pointer

    protected int[] instructionOrder;

    protected KNode startPosition;

    protected KNode location;
    private double id;
    public KNanoBot(String instOrder, KNode start) {
        id = Math.floor(Math.random()*100.0);
        location = start;
        startPosition = start;
        String[] parts = instOrder.split(" ");
        instructionOrder = new int[parts.length];
        alive = true;
        nodesMunched = 1;
        location.mark();
        cycle= 0;
        for (int i = 0; i < parts.length; i++) {
            parts[i] = parts[i].toUpperCase();
            if (parts[i].equals("U")) {
                instructionOrder[i] = UP;
            } else if (parts[i].equals("D")) {
                instructionOrder[i] = DOWN;
            } else if (parts[i].equals("L")) {
                instructionOrder[i] = LEFT;
            } else if (parts[i].equals("R")) {
                instructionOrder[i] = RIGHT;
            }
        }
    }
    public KNode nextMove(){
        positionDelta = 0;
        KNode possible = null;
        while (positionDelta < instructionOrder.length){
            int directionIndex = (cycle+positionDelta) % instructionOrder.length;
            int direction  = instructionOrder[directionIndex];
            switch (direction) {
            case UP:
                possible = getUnmarkedUp();
                break;
            case DOWN:
                possible = getUnmarkedDown();
                break;
            case LEFT:
                possible = getUnmarkedLeft();
                break;
            case RIGHT:
                possible = getUnmarkedRight();
                break;
            }
            if (possible != null){
                return possible;
            }
            positionDelta++;
        }
        return possible;
    }
    private KNode getUnmarkedLeft(){
        KNode[] others = location.getNeighbors();
        int destX = location.getX()-1;
        int destY = location.getY();
        for(int i=0;i<others.length;i++){
            if (others[i].isMarked()){
                continue;
            }
            if ((others[i].getPoint().equals(new Point(destX,destY)))) {
                return others[i];
            }
        }
        return null;
    }
    private KNode getUnmarkedRight(){
        KNode[] others = location.getNeighbors();
        int destX = location.getX()+1;
        int destY = location.getY();
        for(int i=0;i<others.length;i++){
            if (others[i].isMarked()){
                continue;
            }
            if ((others[i].getPoint().equals(new Point(destX,destY)))) {
                return others[i];
            }
        }
        return null;
    }
    private KNode getUnmarkedUp(){
        KNode[] others = location.getNeighbors();
        int destX = location.getX();
        int destY = location.getY()-1;
        for(int i=0;i<others.length;i++){
            if (others[i].isMarked()){
                continue;
            }
            if ((others[i].getPoint().equals(new Point(destX,destY)))) {
                return others[i];
            }
        }
        return null;        
    }
    private KNode getUnmarkedDown(){
        KNode[] others = location.getNeighbors();
        int destX = location.getX();
        int destY = location.getY()+1;
        for(int i=0;i<others.length;i++){
            if (others[i].isMarked()){
                continue;
            }
            if ((others[i].getPoint().equals(new Point(destX,destY)))) {
                return others[i];
            }
        }
        return null;
    }
    public synchronized KNode nextOLDMove() {
        if (alive==false){
            return null;
        }
        int direction = cycle % instructionOrder.length;
        int position = instructionOrder[direction];
        KNode[] others = location.getNeighbors();
        boolean shouldDie = true;
        for (int i = 0; i < others.length; i++) {
            shouldDie = shouldDie && others[i].isMarked();
        }
        if (shouldDie || others.length == 0) {
            return null;
        }
        int chosen = -1;
        while(positionDelta < instructionOrder.length){
            int destX = location.getX();
            int destY = location.getY();
            int nextInstruction = (position+positionDelta) % instructionOrder.length;
            int nextDirection = instructionOrder[nextInstruction]; 
            switch (nextDirection) {
            case UP:
                destY--;
                break;
            case DOWN:
                destY++;
                break;
            case LEFT:
                destX--;
                break;
            case RIGHT:
                destY++;
                break;
            }
            for (int i = 0; i < others.length; i++) {
                if (others[i].isMarked()){
                    continue;
                }
                
                if ((others[i].getPoint().equals(new Point(destX,destY)))) {
                        chosen = i;
                        break;
                }
            }
            if (chosen != -1){
                break;
            }else{
                System.out.println(""+id+" inspecting from "+location+" dir="+nanoDirection(nextDirection)+" Nothiing ");
            }
            positionDelta++;
        }
        if (chosen != -1) {
            return others[chosen];
        }
        return null;
    }

    public void move() {
        KNode home = nextMove();
        if (alive && home != null){
            //System.out.println("Bot is marking graph...");
            int direction = cycle % instructionOrder.length;
            String oldDirection = nanoDirection(instructionOrder[direction]);
            //System.out.println("***"+id+"start "+location+ " Direction is "+ oldDirection+""+direction+" cycle "+cycle);
            home.mark();
            location = home;
            nodesMunched++;
            
            cycle+= 1+positionDelta;
            //cycle++;
            direction = cycle % instructionOrder.length;
            String newDirection = nanoDirection(instructionOrder[direction]);
            
            //System.out.println("***"+id+" end "+location+" facing "+ newDirection+""+direction+" code = "+getCode()+" cycle "+cycle);
        }
        positionDelta = 0;
    }

    public int getDirection() {
        return instructionOrder[(cycle+positionDelta)% instructionOrder.length];
    }

    public int getNodesMunched() {
        return nodesMunched;
    }

    public boolean isAlive() {
        return alive;
    }

    public void kill() {
        alive = false;
    }

    public void clear() {
        cycle= 0;
        location = startPosition;
        nodesMunched = 1;
        location.mark();
        alive = true;
    }

    public KNode getCurrentLocation() {
        return location;
    }
    public String getCode(){
        String nanoCode = "";
        for(int i=0;i<instructionOrder.length;i++){
            nanoCode += nanoDirection(instructionOrder[i]);
        }
        return nanoCode;
    }
    
    private String nanoDirection(int n){
        switch (n){
    	case UP:
    	    return "U";
    	case DOWN:
    	    return "D";
    	case LEFT:
    	    return "L";
    	case RIGHT:
    	    return "R";
    	    
        }
        return "UKNOWN";
    }
}