package nanomunchers;

import java.util.Vector;

import nanomunchers.bot.KNanoBot;
import nanomunchers.bot.KNanoBotWrangler;
import nanomunchers.graph.KGraph;
import nanomunchers.ui.NanoSimulation;
import heurgame.PlayerToken;
import heurgame.analysis.MoveAnalyzer;
import heurgame.analysis.SystemAnalyzer;
/*
 * Created on Oct 27, 2004
 */

/**
 * @author David Kaplin
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class NanoSystemAnalyzer extends SystemAnalyzer {
    private KGraph board;
    private KNanoBotWrangler nanoManager;
    private NanoSimulator nanoSimulator;
    private NanoSimulation uiNanoSim;
    private Vector simulationResults;
    private Vector playerTokens;
    private NanoMoveAnalyzer moveAnalyzer;
    private int maxPlayerBots;
    
    public KGraph getBoard(){
        return board;
    }
    public boolean needMore(PlayerToken owner){
        Vector existingBots = nanoManager.getNanoBots(owner);
        int numBots = existingBots.size();
        if (numBots == maxPlayerBots){
            return false;
        }
        return true;
    }
    public synchronized String getResponse(PlayerToken owner, KNanoBot newBot){
        String response = "";
        synchronized (nanoManager){
        Vector existingBots = nanoManager.getNanoBots(owner);
        int numBots = existingBots.size();
        
        if (numBots == maxPlayerBots){
            response = "Too many bots";
            return response;
        }
        //attempt to add it
        boolean addResult = nanoManager.addNanoBot(owner,newBot);
        if (addResult == false){
            response = "DUPLICATE";
        }else{
            numBots++;
            System.out.println(owner.getName()+" BOTS: "+numBots+" MAX "+ maxPlayerBots);
            if (numBots == maxPlayerBots){
                System.out.println(owner.getName()+"Sys says done");
                return "DONE";
            }else{
                return "NEXT";
            }
        }
        return response;
        }
    }
    public void setup(int maxBots,KGraph nanoField, NanoSimulation ui){
        moveAnalyzer = new NanoMoveAnalyzer(this);
        maxPlayerBots = maxBots;
        board = nanoField;
        nanoManager = new KNanoBotWrangler();
        uiNanoSim = ui;
    }
    public void runSimulation(Vector playerTokens){
        this.playerTokens = playerTokens;
        nanoSimulator = new NanoSimulator(uiNanoSim, board, nanoManager, playerTokens);
        nanoSimulator.prepareSimulation();
        simulationResults = nanoSimulator.feedSimulation();
        uiNanoSim.play();
    }
    /** 
     * @see heurgame.analysis.SystemAnalyzer#isGameOver()
     */
    public boolean isGameOver() {
        return simulationResults != null;
    }

    /** 
     * @see heurgame.analysis.SystemAnalyzer#isDecisive()
     */
    public boolean isDecisive() {
        int max = -1;
        for(int i=0;i<simulationResults.size();i++){
            Integer thisScore = (Integer) simulationResults.get(i);
            if (thisScore.intValue() > max){
                max = thisScore.intValue();
            }
        }
        int count = 0;
        for(int i=0;i<simulationResults.size();i++){
            Integer thisScore = (Integer) simulationResults.get(i);
            if (thisScore.intValue() == max){
                count++;
            }
        }
        return (count==1);
    }

    /** 
     * @see heurgame.analysis.SystemAnalyzer#getWinningPlayer()
     */
    public PlayerToken getWinningPlayer() {
        int max = -1;
        int ndx = -1;
        for(int i=0;i<simulationResults.size();i++){
            Integer thisScore = (Integer) simulationResults.get(i);
            if (thisScore.intValue() > max){
                max = thisScore.intValue();
                ndx = i;
            }
        }
        PlayerToken winner = (PlayerToken)playerTokens.get(ndx);
        System.out.println(winner.getName()+" wins with "+ max);
        return winner;
    }

    /** 
     * @see heurgame.analysis.SystemAnalyzer#getWinningPlayers()
     */
    public PlayerToken[] getWinningPlayers() {
        int max = -1;
        int ndx = -1;
        for(int i=0;i<simulationResults.size();i++){
            Integer thisScore = (Integer) simulationResults.get(i);
            if (thisScore.intValue() > max){
                max = thisScore.intValue();
                ndx = i;
            }
        }
        Vector returnPlayers = new Vector();
        for(int i=0;i<simulationResults.size();i++){
            Integer thisScore = (Integer) simulationResults.get(i);
            if (thisScore.intValue() == max){
                returnPlayers.add(playerTokens.get(i)); 
            }
        }
        PlayerToken[] winners = new PlayerToken[returnPlayers.size()];
        for(int i=0;i<winners.length;i++){
            winners[i] = (PlayerToken) returnPlayers.get(i);
            System.out.println(winners[i].getName()+" wins with "+ max);
        }
        
        
        return winners;
    }

    /** 
     * @see heurgame.analysis.SystemAnalyzer#newGame()
     */
    public void newGame() {
        // TODO Auto-generated method stub

    }

    /** 
     * @see heurgame.analysis.SystemAnalyzer#getMoveAnalyzer()
     */
    public MoveAnalyzer getMoveAnalyzer() {
        return moveAnalyzer;
    }

}
