package nanomunchers;

//import java.awt.BorderLayout;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import nanomunchers.ui.NanoSimulation;

import heurgame.GameServer;
import heurgame.event.GameBroadcaster;
import heurgame.event.PlayerBroadcaster;
import heurgame.event.TimeBroadcaster;
import heurgame.ui.GraphicalLogInterface;
import heurgame.ui.PlayerColors;
import heurgame.ui.ScoreBoard;
import heurgame.ui.WelcomeScreen;

/*
 * Created on Oct 21, 2004
 */

/**
 * @author David Kaplin
 *
 */
public class NanoMain {
    public static int port = 20000;
    public static String hostname = "127.0.0.1";
    public static String graphKind = "complete";
    public static long gameTime = 1000 * 60 * 2;//2 minutes
    public static PlayerColors picasso;
    public static NanoGame game;
    public static NanoRef official;
    public static WelcomeScreen welcome;
    public static WindowAdapter onClose;
    public static TimeBroadcaster timeBroadcaster;
    public static ScoreBoard scoreBoard;
    public static void main(String[] args) {
        if (args.length == 4){
            hostname = args[0];
            port = Integer.parseInt(args[1]);
            graphKind = args[2];
            gameTime = Long.parseLong(args[3]) * 1000;
        }else if (args.length > 0){
            System.out.println("Usage:\n java -jar nanomunchers-1-6.jar");
            System.out.println("\tRuns the Server on 127.0.0.1:20000 with a complete board 25x25 total time usage of 2 minutes plus 30 seconds of warning.");
            System.out.println("Expert Usage:\n java -jar nanomunchers-1-6.jar server_hostname port board game_time");
            System.out.println("Where");
            System.out.println("server_host - is the hostname that the server (this computer)");
            System.out.println("port - valid open port for the server to attach");
            System.out.println("board - either 'random' or 'complete' or a filename to read");
            System.out.println("game_time - Maximum number of seconds a player is allowed over the course of the game.  The warning time is automatically 1/4 of the total time.");
            return;
        }
        game = new NanoGame();
        timeBroadcaster = new TimeBroadcaster();
        game.setTimeBroadcaster(timeBroadcaster);
        GameBroadcaster gameBroadcaster =new GameBroadcaster(); 
        game.setGameBroadcaster(gameBroadcaster);
        final PlayerBroadcaster playerBroadcaster = new PlayerBroadcaster();
        game.setPlayerBroadcaster(playerBroadcaster);
        
        official = new NanoRef();
        game.setupTime(gameTime,gameTime/4);
        game.setReferee(official);
        GameServer server = new GameServer(hostname,port,game,official);
        picasso = new PlayerColors();
        
        Thread sThread = new Thread(server);
        
        
        welcome = new WelcomeScreen(server);
        playerBroadcaster.addPlayerListener(welcome);
        scoreBoard = new ScoreBoard(picasso, false);
        playerBroadcaster.addPlayerListener(scoreBoard);
        gameBroadcaster.addGameListener(scoreBoard);
        final NanoSimulation ns = new NanoSimulation(picasso,playerBroadcaster);
        
        game.setupUI(ns);
        
        playerBroadcaster.addPlayerListener(picasso);
        final Runnable onExit = new Runnable(){
            public void run(){
                System.out.println("Goodbye cruel world.");
                System.exit(0);
            }
        };
        
        onClose = new WindowAdapter(){
            public void windowClosing(WindowEvent w){
                onExit.run();
            }
          };
        Runnable onStart = new Runnable(){
            public void run(){
                (new heurgame.ui.GraphicalLogInterface()).clearLog();
                //final NanoSimulation ns = new NanoSimulation(picasso);
                //game.setupUI(ns);
                game.newGame(2, graphKind, 25, 25);
                
                final Frame mainFrame = new Frame(game.getName());
        		mainFrame.addWindowListener(onClose);
        		mainFrame.setLayout(new BorderLayout());
        		ns.setSize(500,500);
        		mainFrame.add(ns,BorderLayout.CENTER);
        		mainFrame.add(scoreBoard,BorderLayout.EAST);
        		Panel bottom = new Panel();
        		bottom.setLayout(new java.awt.GridLayout(1,3));
        		Button newGame = new Button("New Game");
        		
        		newGame.addActionListener(new java.awt.event.ActionListener(){
        		    public void actionPerformed(java.awt.event.ActionEvent e){
        		        official.rejectAllPlayers("Game Over");
        		        scoreBoard.clear();
        		        mainFrame.hide();
        		        mainFrame.dispose();
        		        welcome.getBuiltWelcome().show();
        			}
        		});
        		bottom.add(newGame);
        		Button replay = new Button("Replay");
        		replay.addActionListener(new java.awt.event.ActionListener(){
        		    public void actionPerformed(java.awt.event.ActionEvent e){
        		       // Thread t = new Thread(){
        		         //   public void run(){
        		                ns.play();        		                
        		           // }
        		        //};
        		        //t.start();
        			}
        		});
        		bottom.add(replay);
        		Button slog = new Button("Log");
        		slog.addActionListener(new java.awt.event.ActionListener(){
        		    public void actionPerformed(java.awt.event.ActionEvent e){
        		        Frame logWind = GraphicalLogInterface.getLogWindow();
        		        logWind.show();
        		    }
        		});
        		bottom.add(slog,java.awt.BorderLayout.EAST);
        		//bottom.add(estTime.getEstimatedTime());
        		mainFrame.add(bottom,java.awt.BorderLayout.SOUTH);
        		Thread g = new Thread(){
        		    public void run(){
        		        
        		        game.start();				        
        		    }
        		};
        		g.start();
        		mainFrame.pack();
        		mainFrame.setResizable(false);
        		mainFrame.show();
        		(welcome.getBuiltWelcome()).hide();
            }
        };
        
        sThread.start();
        Frame first = welcome.getWelcome(onStart,onExit);
        first.pack();
        first.show();
    }
}
