package nanomunchers.graph;

import java.util.Vector;

/*
 * Created on Oct 26, 2004
 */

/**
 * @author David Kaplin
 *
 */
public class KGraphFactory {
    public static KGraph buildRandomized(KGraph src, double chanceNodeRemoved){
        Vector keepNodes = new Vector();
        Vector killNodes = new Vector();
        Vector keepEdges = new Vector();
        KNode[] nodes = src.getNodes();
        KEdge[] edges = src.getUniqueEdges();
        for(int i=0;i<nodes.length;i++){
            if (Math.random()>chanceNodeRemoved){
                killNodes.add(nodes[i]);
            }else{
                keepNodes.add(nodes[i]);
            }
        }
        for(int e=0;e<edges.length;e++){
            boolean keep = true;
            for(int i=0;i<killNodes.size();i++){
                KNode killNode = (KNode)killNodes.get(i);
                if (edges[e].doesContain(killNode)){
                    keep = false;
                    break;
                }
            }
            if (keep){
                keepEdges.add(edges[e]);
            }
        }
        KEdge[] finalEdges = new KEdge[keepEdges.size()];
        KNode[] finalNodes = new KNode[keepNodes.size()];
        for(int i=0;i<finalNodes.length;i++){
            finalNodes[i] = (KNode)keepNodes.get(i); 
        }
        for(int j=0;j<finalEdges.length;j++){
            finalEdges[j] = (KEdge)keepEdges.get(j);
        }
        return buildFromParts(finalNodes,finalEdges);
    }
    public static KGraph buildFromParts(KNode[] nodes, KEdge[] edges){
        return new KGeneralGraph(nodes,edges);
    }
    public static KGraph buildGridGraph(int width,int height){
        return new KGridGraph(width,height);
    }
    /*public static KGraph loadFile(String name){
        
    }*/
}
