package heurgame.logging;

/**
 * @author David Kaplin
 *
 * A LogReader is any component that reads or expected information coming
 * from a log.
 */
public interface LogReader {
    
    /**
     * Callback method from Log when it receives new information.
     * 
     * @param who Name of the component registered with the log. 
     * @param priority 0 is normal, anything higher is more important.
     * @param information Has the actual log information.
     */
    public abstract void readLog(String who,int priority, LogItem information);
    
    /**
     * Resets the reader to its initial state. 
     */
    public abstract void clearLog();
}
