package heurgame.logging;

import java.util.List;
import java.util.Vector;

/*
 * Created on Oct 15, 2004
 */

/**
 * @author David Kaplin
 *
 * I found myself duplicating a lot of code when I was creating loggable
 * components.  This class simplifies the use of logging aspsect of the framework.
 */
public class LogBox implements LogWriter {
    private Vector normal;
    private Vector urgent;
    private AbstractLog logConduit;
    private LogReader reader;
    private String name;
    
    private void setup(){
        normal = new Vector();
        urgent = new Vector();
        reader = new DebugLogReader();
    }
    private void stitch(){
        logConduit.addLogReader(reader);
        logConduit.addLogWriter(this);
        logConduit.startLogging();
    }
    public LogBox(String name){
        this.name = name;
        logConduit = new DefaultLog();
        setup();
        stitch();
    }
    public LogBox(String name,LogReader output){
        this.name = name;
        logConduit = new DefaultLog();
        setup();
        reader = output;
        stitch();
    }
    public LogBox(String name,AbstractLog conduit, LogReader output){
        this.name = name;
        logConduit = conduit;
        setup();
        reader = output;
        stitch();
    }
    public void addEntry(String shortDescription, String longDescription){
        normal.add(new LogItem(shortDescription,longDescription));
    }
    public void addUrgentEntry(String shortDescription, String longDescription, int priority){
        urgent.add(new LogItem(shortDescription,longDescription,priority));
    }
    
    /** 
     * @see heurgame.logging.LogWriter#getLogName()
     */
    public String getLogName() {
        return name;
    }

    /** 
     * @see heurgame.logging.LogWriter#getEntries()
     */
    public List getEntries() {
        return normal;
    }

    /** 
     * @see heurgame.logging.LogWriter#urgentEntries()
     */
    public List urgentEntries() {
        return urgent;
    }

}
