package nanomunchers.ui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import nanomunchers.graph.KEdge;
import nanomunchers.graph.KGraph;
import nanomunchers.graph.KGraphFactory;

/*
 * Created on Oct 26, 2004
 */

/**
 * @author David Kaplin
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class GraphEditPanel extends Canvas{
    private KGraph graph;
    Graphics bufferGraphics;
	Image offscreen;
	boolean[] edgesShown;
	Point[] midpoints;
	int hoffset,woffset;
	int lastWidth=-1;
	int lastHeight = -1;
	
    public GraphEditPanel(){
        graph = KGraphFactory.buildGridGraph(20,10);
        graph = KGraphFactory.buildRandomized(graph,.98);
        edgesShown = new boolean[graph.getUniqueEdges().length];
        midpoints = new Point[graph.getUniqueEdges().length];
        for(int i=0;i<edgesShown.length;i++){
            edgesShown[i] = true;
        }
        Thread paintThread = new Thread(){
            public void run(){
                while(true){
                try {
                    Thread.sleep(100);
                }catch (InterruptedException e){
                    
                }
                repaint();
                }
            }
        };
        paintThread.start();
        addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                
                int ex = e.getX();
                int ey = e.getY();
                int closest = -1;
                double bestdist = 10000;
                for(int i=0;i<midpoints.length;i++){
                    Point p = midpoints[i];
                    int dx = (ex> p.x) ? ex - p.x : p.x - ex;
                    int dy = (ey> p.y) ? ey - p.y : p.y - ey;
                    double dist = Math.sqrt(dx*dx +dy*dy);
                    if (dist < bestdist){
                        closest = i;
                        bestdist = dist;
                    }
                }
                edgesShown[closest] = !edgesShown[closest];
                //repaint();
                //edgesShown[x + y*graph.getWidth()] = !edgesShown[x + y*graph.getWidth()]; 
                
            }

            public void mouseEntered(MouseEvent e) {
                // TODO Auto-generated method stub
                
            }

            public void mouseExited(MouseEvent e) {
                // TODO Auto-generated method stub
                
            }

            public void mousePressed(MouseEvent e) {
                // TODO Auto-generated method stub
                
            }

            public void mouseReleased(MouseEvent e) {
                // TODO Auto-generated method stub
                
            }
            
        });
    }
    public void update(Graphics g){
        int width = getWidth();
        int height = getHeight();
        if (offscreen == null || (width != lastWidth) || (height != lastHeight)) {
			offscreen = createImage(width, height);
			bufferGraphics = offscreen.getGraphics();
		}
        lastWidth = width;
        lastHeight = height;
        bufferGraphics.setColor(Color.white); //getBackground());
		bufferGraphics.fillRect(0, 0, width, height);
        
        //g.translate(0,-1);
        woffset = width/(graph.getWidth()+1);
        hoffset = height/(graph.getHeight()+1);
        bufferGraphics.setColor(new Color(0,0,0));
        if (((width+1) > graph.getWidth()) && ((height+1) > graph.getHeight())){
            KEdge[] edges = graph.getUniqueEdges();
            int sx,sy,dx,dy;
            for(int i=0;i<edges.length;i++){
                if (edgesShown[i]){
                    bufferGraphics.setColor(new Color(0,0,0));
                }else{
                    bufferGraphics.setColor(new Color(128,128,128));
                }
                    sx = woffset + woffset*edges[i].getNodes()[0].getX();
                    dx = woffset + woffset*edges[i].getNodes()[1].getX();
                    sy = hoffset + hoffset*edges[i].getNodes()[0].getY();
                    dy = hoffset + hoffset*edges[i].getNodes()[1].getY();
                    midpoints[i] = new Point((sx+dx)/2,(sy+dy)/2);
                    bufferGraphics.drawLine(sx,sy,dx,dy);
                    
                    if (edgesShown[i]){
                        bufferGraphics.drawLine(sx,sy+1,dx,dy+1);
                        bufferGraphics.drawLine(sx+1,sy,dx+1,dy);
                        bufferGraphics.drawLine(sx,sy-1,dx,dy-1);
                        bufferGraphics.drawLine(sx-1,sy,dx-1,dy);
                        bufferGraphics.drawOval(sx-5,sy-5,10,10);
                        bufferGraphics.drawOval(dx-5,dy-5,10,10);
                    }
                    
                
            }
        }
        //g.translate(0,1);
        g.drawImage(offscreen, 0, 0, this);
    }
    public static void main(String args[]){
        final Frame f = new Frame("Graph Editor");
        f.setLayout(new java.awt.BorderLayout());
        GraphEditPanel gep = new GraphEditPanel();
        gep.setSize(500,350);
        f.add(gep);
        
        f.addWindowListener(new WindowAdapter(){
            public void windowClosing(WindowEvent e){
                f.dispose();
                System.exit(1);
            }
        });
        f.pack();
        f.show();
    }
}
