package heurgame.event;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/*
 * Created on Oct 26, 2004
 */

/**
 * @author David Kaplin
 */
public class PlayerBroadcaster {
    public static final int PLAYER_JOIN = 0;
    public static final int PLAYER_MOVE = 1;
    public static final int PLAYER_STATUS = 2;
    public static final int PLAYER_LEAVE = 3;
    
    protected boolean simultaneous;
    protected List listeners;
    
    public PlayerBroadcaster(){
        simultaneous = false;
        listeners = new Vector();
    }
    public void addPlayerListener(PlayerListener l){
        if (listeners.contains(l)){
            return;
        }
        listeners.add(l);
    }
    public void removePlayerListener(PlayerListener l){
        listeners.remove(l);
    }
    public void removeAllPlayerListeners(){
        listeners.clear();
    }
    public void announcePlayerJoined(PlayerEvent e){
        dispatch(e,PlayerBroadcaster.PLAYER_JOIN);   
    }
    public void announcePlayerLeft(PlayerEvent e){
        dispatch(e,PlayerBroadcaster.PLAYER_LEAVE);
    }
    public void announcePlayerMoved(PlayerEvent e){
        dispatch(e,PlayerBroadcaster.PLAYER_MOVE);
    }
    public void announcePlayerStatusChanged(PlayerEvent e){
        dispatch(e,PlayerBroadcaster.PLAYER_STATUS);
    }
    protected void dispatch(PlayerEvent e,int kind){
        Iterator i = listeners.iterator();
        if (simultaneous){
            while(i.hasNext()){
                PlayerListener p = (PlayerListener)i.next();
                PlayerEventDispatcher hermes = new PlayerEventDispatcher(p,e,kind);
                Thread t = new Thread(hermes);
                t.start();
            }
            return;
        }
        while(i.hasNext()){
            PlayerListener p = (PlayerListener)i.next();
            PlayerEventDispatcher hermes = new PlayerEventDispatcher(p,e,kind);
            hermes.run();
        }
    }
}

class PlayerEventDispatcher implements Runnable{
    private PlayerListener toGet;
    private PlayerEvent toSend;
    private int mode;
    PlayerEventDispatcher(PlayerListener target, PlayerEvent message, int type){
        toGet = target;
        toSend = message;
        mode = type;
    }
    /** 
     * @see java.lang.Runnable#run()
     */
    public void run() {
        switch (mode){
        	case PlayerBroadcaster.PLAYER_JOIN:
        	    toGet.playerJoined(toSend);
        	    break;
        	case PlayerBroadcaster.PLAYER_LEAVE:
        	    toGet.playerLeft(toSend);
        	    break;
        	case PlayerBroadcaster.PLAYER_MOVE:
        	    toGet.playerMoved(toSend);
        	    break;
        	case PlayerBroadcaster.PLAYER_STATUS:
        	    toGet.playerStatusChanged(toSend);
        	    break;
        }
    }
}