package nanomunchers.graph;

import java.util.Vector;

/*
 * Created on Oct 26, 2004
 */

/**
 * A very general graph.  No structural restrictions.
 * 
 * @author David Kaplin
 */
class GeneralGraph implements Graph {
    private Node[] nodes;
    private Edge[] edges;
    
    private int width;
    private int height;
    
    /**
     * Use the GraphFactory to build
     * @param inNodes
     * @param inEdges
     */
    protected GeneralGraph(Node[] inNodes, Edge[] inEdges){
        reassignNodes(inEdges);
    }
    private void reassignNodes(Edge[] inEdges){
        Vector knownInformation = new Vector();
        Vector knownNodes = new Vector();
        int width = 0;
        int height = 0;
        for(int i=0;i<inEdges.length;i++){
            Node[] edges = inEdges[i].getNodes();
            Integer a = new Integer(edges[0].getId());
            Integer b = new Integer(edges[1].getId());
            if (knownNodes.indexOf(a)==-1){
                knownNodes.add(a);
                knownInformation.add(edges[0]);
                if (edges[0].getX()>width){
                    width = edges[0].getX();
                }
                if (edges[0].getY()>height){
                    height = edges[0].getY();
                }
            }
            if (knownNodes.indexOf(b)==-1){
                knownNodes.add(b);
                knownInformation.add(edges[1]);
                if (edges[1].getX()>width){
                    width = edges[1].getX();
                }
                if (edges[1].getY()>height){
                    height = edges[1].getY();
                }
            }
        }
        //Generate the new nodes
        nodes = new Node[knownNodes.size()];
        for(int i=0;i<nodes.length;i++){
            Node basis = (Node)knownInformation.get(i);
            nodes[i] = new Node(this,i,basis.getX(),basis.getY());
        }
        //Generate the new edges
        edges = new Edge[inEdges.length];
        for(int e=0;e<edges.length;e++){
            Edge original = inEdges[e];
            Node[] nodeRef = original.getNodes();
            int idOldOne = nodeRef[0].getId();
            int idOldTwo = nodeRef[1].getId();
            int newIdOne = knownNodes.indexOf(new Integer(idOldOne));
            int newIdTwo = knownNodes.indexOf(new Integer(idOldTwo));
            edges[e] = new Edge(nodes[newIdOne],nodes[newIdTwo]);
        }
        this.width = width + 1;
        this.height = height + 1;
    }
    /** 
     * @see nanomunchers.graph.Graph#getNodes()
     */
    public Node[] getNodes() {
        return nodes;
    }

    /** 
     * @see nanomunchers.graph.Graph#getUniqueEdges()
     */
    public Edge[] getUniqueEdges() {
        return edges;
    }

    /** 
     * @see nanomunchers.graph.Graph#getConnectedComponents()
     */
    public Graph[] getConnectedComponents() {
        clear();
        boolean allSeen = false;
        Vector graphs = new Vector();
        while(allSeen == false){
            allSeen = true;
            int index = 0;
            for(index=0;index<nodes.length;index++){
                allSeen = allSeen && nodes[index].isMarked();
                if (allSeen==false){
                    break;
                }
            }
            Vector ccNodes = new Vector();
            Vector ccEdges = new Vector();
            connectedComponentBuilder(nodes[index],ccNodes,ccEdges);
            Node[] newNodes = new Node[ccNodes.size()];
            Edge[] newEdges = new Edge[ccEdges.size()];
            for(int i=0;i<newNodes.length;i++){
                newNodes[i] = (Node)ccNodes.get(i);
            }
            for(int j=0;j<newEdges.length;j++){
                newEdges[j]= (Edge)ccEdges.get(j);
            }
            graphs.add(GraphFactory.buildFromParts(newNodes,newEdges));
        }
        Graph[] cc = new Graph[graphs.size()];
        for(int i=0;i<graphs.size();i++){
            cc[i] = (Graph)graphs.get(i);
        }
        clear();
        return cc;
    }
    private void connectedComponentBuilder(Node start,Vector vnodes,Vector vedges){
        vnodes.add(start);
        start.mark();
        Edge[] neighbors = getNeighbors(start);
        Vector otherlist = new Vector();
        for(int n=0;n<neighbors.length;n++){
            Node other = neighbors[n].getOther(start);
            if (other.isMarked()==false){
                otherlist.add(other);
                vedges.add(neighbors[n]);
            }
        }
        for(int i=0;i<otherlist.size();i++){
            Node next = (Node)otherlist.get(i);
            connectedComponentBuilder(next,vnodes,vedges);
        }
        
    }
    /** 
     * @see nanomunchers.graph.Graph#clear()
     */
    public void clear() {
        for(int i=0;i<nodes.length;i++){
            nodes[i].clear();
        }
    }

    /** 
     * @see nanomunchers.graph.Graph#getNeighbors(nanomunchers.graph.Node)
     */
    public Edge[] getNeighbors(Node n) {
        Vector neighbors = new Vector();
        for(int i=0;i<edges.length;i++){
            Edge test = edges[i];
            if (test.doesContain(n)){
                neighbors.add(test);
            }
        }
        Edge[] ret = new Edge[neighbors.size()];
        for(int i=0;i<ret.length;i++){
            ret[i] = (Edge)neighbors.get(i);
        }
        return ret;
    }
    public int getWidth(){ return width;}
    public int getHeight() { return height;}
}
