package nanomunchers;

import heurgame.PlayerToken;

import java.awt.Point;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

import nanomunchers.bot.NanoBot;
import nanomunchers.bot.NanoBotWrangler;
import nanomunchers.graph.Graph;
import nanomunchers.graph.Node;
import nanomunchers.ui.NanoSimulation;

/*
 * Created on Oct 27, 2004
 */

/**
 * Simulates the battle of the nanomunchers.
 * Makes Life and Death decisions
 * 
 * @author David Kaplin
 */
public class NanoSimulator {
    private Graph graph;
    private NanoBotWrangler nanoWrangler;
    private Vector playerTokens;
    private NanoSimulation visualization;
    private Hashtable botToID;
    /**
     * @param sim To be updated with new frames
     * @param board where the game will take place
     * @param wrangler in charge of ownership of nanobots
     * @param players that will be in this game.
     */
    public NanoSimulator(NanoSimulation sim, Graph board, NanoBotWrangler wrangler,Vector players ){
        visualization = sim;
        graph = board;
        nanoWrangler= wrangler;
        Hashtable botToID = new Hashtable();
        playerTokens = players;
        
    }
    /**
     * Removes any duplicates
     * ensures all bots are alive and registered with the simulation.
     */
    public synchronized void prepareSimulation(){
        botToID = new Hashtable();
        //first ensure bots are in the right places
        nanoWrangler.removeDuplicates();
        for(int i=0;i<playerTokens.size();i++){
            PlayerToken owner = (PlayerToken)playerTokens.get(i);
            Vector bots = nanoWrangler.getNanoBots(owner);
            System.out.println(owner.getName()+" has "+ bots.size());
            for(int k=0;k<bots.size();k++){
                NanoBot bot = (NanoBot)bots.get(k);
                Integer id = visualization.register(owner,bot);
                System.out.println("bot "+bot +" id "+id + " is Alive= "+ bot.isAlive());
                botToID.put(bot,id);
            }
        }
    }
    /**
     * Feeds the game information to the simulation
     * move by move, frame by frame.
     * 
     * Based on the current and future positions of
     * nanomunchers decides whether or not they live or die.
     * 
     * @return The results of the simulation
     */
    public Vector feedSimulation(){
        Set nanos = botToID.keySet();
        int numdead = 0;
        int allbots = nanos.size();
        Iterator i = nanos.iterator();
        while(i.hasNext()){
            NanoBot bot = (NanoBot)i.next();
            Integer compId = (Integer) botToID.get(bot);
            visualization.nextMove(compId,bot.getCurrentLocation(),0,bot.isAlive(),true);
        }
        visualization.nextFrame();
        while(numdead < allbots){
            nanos = botToID.keySet();
            Hashtable potential = new Hashtable();
            i = nanos.iterator();
            numdead = 0;
            while(i.hasNext()){
                NanoBot bot = (NanoBot)i.next();
                Node nextSpot = bot.nextMove();
                if (nextSpot==null || bot.isAlive()==false){
                    numdead++;
                    bot.kill();
                    nextSpot = bot.getCurrentLocation(); 
                }
                Point nextPlace = nextSpot.getPoint();
                if (potential.get(nextPlace) == null){
                    potential.put(nextPlace,new Vector());
                }
                Vector botsAtSpot = (Vector) potential.get(nextPlace);
                botsAtSpot.add(bot);
            }
            //kill the weak
            Set conflictedPlaces = potential.keySet();
            Iterator c = conflictedPlaces.iterator();
            while(c.hasNext()){
                
                Vector competators = (Vector)potential.get(c.next());
                if (competators.size()>1){
                    //Nanobots duke it out
                    int maxDirection =-1;
                    int chosen = -1;
                    for(int j=0;j<competators.size();j++){
                        NanoBot bot = (NanoBot)competators.get(j);
                        int tDirection = bot.getDirection();
                        if (tDirection > maxDirection){
                            chosen = j;
                            maxDirection = tDirection;
                        }
                    }
                    for(int j=0;j<competators.size();j++){
                        NanoBot bot = (NanoBot)competators.get(j);
                        Integer compId = (Integer) botToID.get(bot);
                        Node destination = bot.nextMove();
                        boolean naturaldeath = true;
                        if (j!=chosen){
                            bot.kill();
                            //numdead++;
                            destination = bot.getCurrentLocation();
                            naturaldeath = false;
                        }else{
                            bot.move();
                        }
                        visualization.nextMove(compId,destination,bot.getNodesMunched(),bot.isAlive(),naturaldeath);
                        
                    }
                }else if (competators.size()==1){
                    //No competition
                    NanoBot bot = (NanoBot)competators.get(0);
                    Integer compId = (Integer) botToID.get(bot);
                    
                    Node destination = bot.nextMove();
                    if (destination==null || bot.isAlive()==false){
                        destination = bot.getCurrentLocation(); 
                    }
                    bot.move();
                    visualization.nextMove(compId,destination,bot.getNodesMunched(),bot.isAlive(),true);
                }
            }
            visualization.nextFrame();
        }
        //Tally results
        Vector results = new Vector();
        for(int r=0;r<playerTokens.size();r++){
            int playerTotal = 0;
            Vector playerBots = nanoWrangler.getNanoBots((PlayerToken) playerTokens.get(r));
            for(int j=0;j<playerBots.size();j++){
                playerTotal += ((NanoBot)playerBots.get(j)).getNodesMunched();
            }
            results.add(new Integer(playerTotal));
        }
        return results;
    }
}
