package nanomunchers.ui;

import heurgame.PlayerToken;
import heurgame.event.PlayerBroadcaster;
import heurgame.event.PlayerEvent;
import heurgame.ui.PlayerColors;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
//import java.awt.Point;
//import java.awt.event.MouseEvent;
//import java.awt.event.MouseListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

import nanomunchers.bot.KNanoBot;
import nanomunchers.graph.KEdge;
import nanomunchers.graph.KGraph;
//import nanomunchers.graph.KGraphFactory;
import nanomunchers.graph.KNode;
/*
 * Created on Oct 27, 2004
 */

/**
 * @author David Kaplin
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class NanoSimulation extends Canvas {
    private KGraph graph;
    Graphics bufferGraphics;
	Image offscreen;
	int hoffset,woffset;
	int lastWidth=-1;
	int lastHeight = -1;
	private PlayerColors playerColors;
	private PlayerToken[] eaten;
	private Vector edgeLookup;
	private Vector currentFrame;
	private Vector allFrames;
	private Hashtable nanoDeath;
	private Hashtable nanoLookup;
	private Hashtable playerLookup;
	double interpolation = .1;
	double currentPosition = 0;
	private Hashtable nanoPlacesStart;
	private Hashtable nanoPlacesEnd;
	private PlayerBroadcaster playerSpeaker;
	private boolean simulationRunning = false;
	private boolean showNames = true;
	private boolean showCodes = true;
    private GraphDrawing graphDrawing = new GraphDrawing();
	
	public void setup(KGraph graph){

	    this.graph = graph;
	    graphDrawing.setGraph(graph);
	    eaten = new PlayerToken[graph.getUniqueEdges().length];
	    edgeLookup = new Vector();
	    for(int i=0;i<graph.getNodes().length;i++){
	        edgeLookup.add(graph.getNodes()[i]);
	        //eaten[i]=null;
	    }
	    for(int i=0;i<eaten.length;i++){
	        eaten[i] = null;
	    }
	    nanoLookup = new Hashtable();
	    playerLookup = new Hashtable();
	    nanoPlacesStart = new Hashtable();
	    nanoPlacesEnd = new Hashtable();
	    currentFrame = new Vector();
	    allFrames = new Vector();
	}
	public Integer register(PlayerToken owner, KNanoBot nb){
	    Integer id = new Integer(nanoLookup.size());
	    nanoLookup.put(id,nb);
	    playerLookup.put(id,owner);
	    return id;
	}
	public void nextMove(Integer nanoId, KNode place,int munched,boolean alive,boolean naturaldeath){
	    NanoBit bit = new NanoBit();
	    bit.id = nanoId;
	    bit.spot = place;
	    bit.dead = !alive;
	    bit.diedNaturally = naturaldeath;
	    bit.munched = munched;
	    graph = place.getGraph();
	    graphDrawing.setGraph(graph);
	    currentFrame.add(bit);
	}
	public void nextFrame(){
	    System.out.println("Next Frame called "+ allFrames.size());
	    allFrames.add(currentFrame);
	    currentFrame = new Vector();
	}
	public void play(){
	    nanoDeath = new Hashtable();
	    simulationRunning = true;
	    graph.clear();
	    for(int i=0;i<eaten.length;i++){
	        eaten[i]=null;
	    }
	    for(int i=0;i<nanoLookup.size();i++){
	        KNanoBot bot = (KNanoBot)nanoLookup.get(new Integer(i));
	        bot.clear();
	    }
	    for(int i=0;i<(allFrames.size()-1);i++){
	        Vector thisFrame = (Vector)allFrames.get(i);
	        Hashtable currentScores = new Hashtable();
	        for(int j=0;j<thisFrame.size();j++){
                NanoBit bit = (NanoBit)thisFrame.get(j);
                PlayerToken owner = (PlayerToken)playerLookup.get(bit.id);
                
                if (currentScores.get(owner)==null){
                    currentScores.put(owner,new Integer(0));
                }
                int runningScore = ((Integer)currentScores.get(owner)).intValue(); 
                currentScores.put(owner,new Integer(runningScore+bit.munched));
            }
	        Iterator siterator = currentScores.keySet().iterator();
	        while(siterator.hasNext()){
	            PlayerToken who = (PlayerToken)siterator.next();
	            //System.out.println("Who is "+who);
	            PlayerEvent e = new PlayerEvent();
	            e.player = who;
	            e.disqualified=false;
	            e.leader=false;
	            e.score = ((Integer)currentScores.get(who)).intValue();
	            e.validMove = true;//might not be necessary
	            playerSpeaker.announcePlayerMoved(e);
	            playerSpeaker.announcePlayerStatusChanged(e);
	        }
	        synchronized (nanoLookup){
	            //nanoPlacesStart.clear();
	            //nanoPlacesEnd.clear();
	            for(int j=0;j<thisFrame.size();j++){
	                NanoBit bit = (NanoBit)thisFrame.get(j);
	                KNanoBot bot = (KNanoBot)nanoLookup.get(bit.id);
	                nanoPlacesStart.put(bit.id,bit.spot);
	                if (nanoDeath.get(bit.id)!=null){
	                    if (((Boolean)nanoDeath.get(bit.id)).booleanValue()==false){
	                        continue;
	                    }
	                }
	                nanoDeath.put(bit.id,new Boolean(bit.diedNaturally));
	                //int spotIndex = edgeLookup.indexOf(bit.spot);
	                //eaten[spotIndex] = (PlayerToken)playerLookup.get(bit.id);
	            }
	            Vector nextFrame = (Vector)allFrames.get(i+1);
	            for(int j=0;j<nextFrame.size();j++){
	                NanoBit bit = (NanoBit)nextFrame.get(j);
	                KNanoBot bot = (KNanoBot)nanoLookup.get(bit.id);
	                nanoPlacesEnd.put(bit.id,bit.spot);
	                if (nanoDeath.get(bit.id)!=null){
	                    if (((Boolean)nanoDeath.get(bit.id)).booleanValue()==false){
	                        continue;
	                    }
	                }
	                nanoDeath.put(bit.id,new Boolean(bit.diedNaturally));
	                //int spotIndex = edgeLookup.indexOf(bit.spot);
	                //eaten[spotIndex] = (PlayerToken)playerLookup.get(bit.id);
	            }
	            Set s = nanoLookup.keySet();
	            Iterator edges = s.iterator();
	            while (edges.hasNext()){
	                Integer id = (Integer)edges.next();
	                KNode a = (KNode)nanoPlacesEnd.get(id);
	                KNode b = (KNode)nanoPlacesStart.get(id);
	                if (a==null || b==null){
	                    continue;
	                }
	                if (a.getPoint().equals(b.getPoint())){
	                    continue;
	                }
	                KEdge[] gEdges =graph.getUniqueEdges(); 
	                for(int e=0;e<gEdges.length;e++){
	                    if (gEdges[e].doesContain(a) &&gEdges[e].doesContain(b)){
	                        eaten[e] = (PlayerToken)playerLookup.get(id);
	                    }
	                }
	            }
	            currentScores = new Hashtable();
		        for(int j=0;j<nextFrame.size();j++){
	                NanoBit bit = (NanoBit)nextFrame.get(j);
	                PlayerToken owner = (PlayerToken)playerLookup.get(bit.id);
	                
	                if (currentScores.get(owner)==null){
	                    currentScores.put(owner,new Integer(0));
	                }
	                int runningScore = ((Integer)currentScores.get(owner)).intValue(); 
	                currentScores.put(owner,new Integer(runningScore+bit.munched));
	            }
		        siterator = currentScores.keySet().iterator();
		        while(siterator.hasNext()){
		            PlayerToken who = (PlayerToken)siterator.next();
		            //System.out.println("Who is "+who);
		            PlayerEvent e = new PlayerEvent();
		            e.player = who;
		            e.disqualified=false;
		            e.leader=false;
		            e.score = ((Integer)currentScores.get(who)).intValue();
		            e.validMove = true;//might not be necessary
		            playerSpeaker.announcePlayerMoved(e);
		            playerSpeaker.announcePlayerStatusChanged(e);
		        }
		        while(currentPosition <= 1.0){
		            try {
		                //repaint();
		                update(this.getGraphics());
		                currentPosition += interpolation;
		                Thread.sleep(80);
		                
		            } catch (InterruptedException e){
		            
		            }
		        }
		        //Report scores here.
	        }
	        currentPosition = 0;
	    }
	    simulationRunning = false;
	}
    public NanoSimulation(PlayerColors pc,PlayerBroadcaster playerSpeaker){
	    this.playerSpeaker = playerSpeaker;
        playerColors = pc;
        addMouseListener(new MouseAdapter(){
            private int clickCount = 0;
            public void mouseClicked(MouseEvent e){
                Thread t = new Thread(){
                    public void run(){
                        clickCount++;
                        clickCount%=4;
                        switch(clickCount){
                        	case 0:
                        	    showNames = true;
                        	    showCodes = true;
                        	break;
                        	case 1:
                        	    showNames = true;
                        	    showCodes = false;
                        	break;
                        	case 2:
                        	    showNames = false;
                        	    showCodes = true;
                        	break;
                        	case 3:
                        	    showNames = false;
                        	    showCodes = false;
                        	break;
                        }
                        
                        if (simulationRunning==false){
                            repaint();
                        }                            
                    }
                    
                };
                t.start();
            }
        });
    }
    public void paint(Graphics g){
        if (simulationRunning){
            return;
        }
        update(g);
    }
    public void update(Graphics g){
        if (graph==null){
            return;
        }
        int width = getWidth();
        int height = getHeight();
        if (offscreen == null || (width != lastWidth) || (height != lastHeight)) {
			offscreen = createImage(width, height);
			bufferGraphics = offscreen.getGraphics();
		}
        lastWidth = width;
        lastHeight = height;
        bufferGraphics.setColor(Color.black); //getBackground());
		bufferGraphics.fillRect(0, 0, width, height);
        
        woffset = width/(graph.getWidth()+1);
        hoffset = height/(graph.getHeight()+1);
        bufferGraphics.setColor(new Color(0,0,0));
        if (((width+1) > graph.getWidth()) && ((height+1) > graph.getHeight())){
            graphDrawing.drawGraph(bufferGraphics,Color.GRAY,width,height);
            int nanoRad = (width < height) ? woffset/5 : hoffset/5;
            KEdge[] edges = graph.getUniqueEdges();
            int sx,sy,dx,dy;
            for(int i=0;i<edges.length;i++){
                if (eaten[i]!=null){
                    graphDrawing.highlightEdge(bufferGraphics,playerColors.getColor(eaten[i]),edges[i],4);                    
                }
            }
            //draw the bots
            for(int i=0;i<nanoPlacesStart.size();i++){
                
                Integer id = new Integer(i);
                KNode start = (KNode)nanoPlacesStart.get(id);
                KNode end =   (KNode)nanoPlacesEnd.get(id);
                
                if (end==null){
                    end = start;
                }
                sx = woffset + woffset*start.getX();
                dx = woffset + woffset*end.getX();
                sy = hoffset + hoffset*start.getY();
                dy = hoffset + hoffset*end.getY();
                
                int ix = (int)((double)sx + ((double)(dx - sx))*currentPosition);
                int iy = (int)((double)sy + ((double)(dy - sy))*currentPosition);
                PlayerToken thisOwner = (PlayerToken)playerLookup.get(id);
                Color playerColor = playerColors.getColor(thisOwner);
                bufferGraphics.setColor(playerColor);
                KNanoBot bot = (KNanoBot)nanoLookup.get(id);
                boolean conflictedDeath = false;
                
                if (sx!=dx || sy!=dy){
                    //bufferGraphics.fill3DRect(ix-nanoRad,iy-nanoRad,2*nanoRad,2*nanoRad,true);
                    graphDrawing.drawBotAlive(bufferGraphics,playerColor,ix,iy,dx,dy);
                }else{
                    boolean naturalCauses = ((Boolean)nanoDeath.get(id)).booleanValue();
                    //bufferGraphics.fill3DRect(ix-nanoRad,iy-nanoRad,2*nanoRad,2*nanoRad,false);
                    if (naturalCauses == false){
                        graphDrawing.drawBotSlain(bufferGraphics,playerColor,ix,iy,dx,dy);
                    }else{
                        graphDrawing.drawBotDead(bufferGraphics,playerColor,ix,iy,dx,dy);
                    }
                }
                bufferGraphics.setColor(Color.gray);
                if (showCodes){
                    bufferGraphics.fillRect(dx-15,dy+5,30,10);
                }
                if (showNames){
                    bufferGraphics.fillRect(dx-15,dy-15,30,10);
                }
                bufferGraphics.setColor(Color.white);
                if (showCodes){
                bufferGraphics.drawString(bot.getCode(),dx-15,dy+15);
                }
                if (showNames){
                    bufferGraphics.drawString(thisOwner.getName(),dx-15,dy-5);
                }
            }
        }
        g.drawImage(offscreen, 0, 0, this);
    }
    public static void main(String args[]){
        final Frame f = new Frame("NanoSimulation");
        f.setLayout(new java.awt.BorderLayout());
        GraphEditPanel gep = new GraphEditPanel();
        gep.setSize(500,350);
        f.add(gep);
        
        f.addWindowListener(new WindowAdapter(){
            public void windowClosing(WindowEvent e){
                f.dispose();
                System.exit(1);
            }
        });
        f.pack();
        f.show();
    }
    
    class NanoBit{
        public Integer id;
        public KNode spot;
        public boolean dead;
        public boolean diedNaturally;
        public int munched;
    }
}
