package heurgame.analysis;
import heurgame.PlayerToken;
/**
 * @author David Kaplin
 *
 * A place to keep the logic that determines players standings
 * within a game.
 * 
 * May work in concert with the MoveAnalyzer when an individual
 * moves during the game.
 */
public abstract class SystemAnalyzer {
    abstract public boolean isGameOver();
    abstract public boolean isDecisive();
    abstract public PlayerToken getWinningPlayer();
    abstract public PlayerToken[] getWinningPlayers();
    abstract public void newGame();
    abstract public MoveAnalyzer getMoveAnalyzer();
}
