package nanomunchers.graph;

import java.awt.Point;

/*
 * Created on Oct 26, 2004
 */

/**
 * @author David Kaplin
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class KNode {
    private int id;
    private boolean marked;
    private Point gridPosition;
    private KGraph parent;
    public KNode(KGraph owner,int id, int x, int y){
        this.id = id;
        gridPosition = new Point(x,y);
        parent = owner;
    }
    public int getId(){
        return id;
    }
    public int getX(){
        return gridPosition.x;
    }
    public Point getPoint(){
        return gridPosition;
    }
    public int getY(){
        return gridPosition.y;
    }
    public void mark(){
        marked=true;
    }
    public boolean isMarked(){
        return marked;
    }
    public void clear(){
        marked=false;
    }
    public String toString(){
        return ""+id +" "+ gridPosition.x+" "+gridPosition.y;
    }
    public KNode[] getNeighbors(){
        KEdge[] paths = parent.getNeighbors(this);
        KNode[] others = new KNode[paths.length];
        for(int p=0;p<paths.length;p++){
           others[p] = paths[p].getOther(this); 
        }
        return others;
    }
    public KGraph getGraph(){
        return parent;
    }
}
