/*
 * Created on Oct 11, 2004
 */

package heurgame.analysis;
import heurgame.PlayerToken;
/**
 * @author David Kaplin
 * 
 * The role of the MoveAnalyzer is to separate some of the logic for
 * validating individual moves in a game.  In some cases this might
 * not be possible, so communication between the MoveAnalyzer and the
 * SystemAnalyzer is encouraged.
 * 
 * The Referee works closely with the MoveAnalyzer each turn.
 * 
 */
public abstract class MoveAnalyzer {
    /**
     * <code>MOVE_VALID</code> A Valid and accepted Move.
     */
    public static final String MOVE_VALID = "OK ";
    /**
     * <code>MOVE_DISQUALIFIED</code> The start of a response that
     * is the reason for a players ejection.
     */
    public static final String MOVE_DISQUALIFIED = "DISQUALIFIED ";
    /**
     * <code>MOVE_INVALID</code> The start of a rejection of
     * the move.   
     */
    public static final String MOVE_INVALID = "INVALID ";
    /**
     * <code>parent</code> Delegated to for checking for duplicates 
     * and other minutia.
     */
    protected SystemAnalyzer parent;

    /**
     * @param move Game specific string about the move the player made
     * @param senderToken	The player involved with the move
     * @param timeTaken		Time to get the move from the player
     * @return A string either begining with MOVE_VALID for valid moves
     * or a string beginning with MOVE_INVALID for all other cases.
     */
    abstract public String evaluateMove(String move,PlayerToken senderToken,long timeTaken);
  
}
