package heurgame.ui;

import heurgame.PlayerToken;
import heurgame.event.GameEvent;
import heurgame.event.GameListener;
import heurgame.event.PlayerEvent;
import heurgame.event.PlayerListener;
import heurgame.event.TurnEvent;
import heurgame.event.TurnListener;

import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.util.HashMap;
import java.util.Collections;
import java.util.Map;
/*
 * Created on Oct 13, 2004
 */

/**
 * @author David Kaplin
 */
public class ScoreBoard extends Container implements PlayerListener,TurnListener,GameListener{
    private PlayerColors playerColors;
    private HashMap activePart = new HashMap();
    private Map scorePart = Collections.synchronizedMap(  new HashMap());
    private boolean turnAware;
    public ScoreBoard(PlayerColors pc,boolean turnAware){
        playerColors = pc;
        GridLayout g = new GridLayout();
        g.setRows(5);
        setLayout(g);
        this.turnAware = turnAware;
    }
    public void clear(){
        activePart.clear();
        scorePart.clear();
        this.removeAll();
    }
    private Panel buildNewListing(PlayerToken t){
        Panel p = new Panel();
        p.setLayout(new GridLayout(3,1));
        
        Label nameLabel = new Label(t.getName());
        java.awt.Color playerColor = playerColors.getColor(t);
        nameLabel.setBackground(playerColor);
        p.add(nameLabel);
        
        Label activeLabel = new Label("-");
        activePart.put(t,activeLabel);
        activeLabel.setBackground(playerColor);
        p.add(activeLabel);
        
        Label scoreLabel = new Label("-");
        scoreLabel.setBackground(playerColor);
        scorePart.put(t,scoreLabel);
        p.add(scoreLabel);
        return p;
    }
    private void updateActive(PlayerToken t, String active){
        Label actLabel = (Label)activePart.get(t);
        if (actLabel != null && active.length()>0){
            if (actLabel.getText().equals("DISQUALIFIED") ==false){
                actLabel.setText(active);                
            }
            
        }
        ensureWindowFits();
    }
    private void updateScore(PlayerToken t, double score){
        Label scoreLabel = (Label)scorePart.get(t);
        if (scoreLabel != null && score >= 0){
            scoreLabel.setText(""+ score);
        }
        ensureWindowFits();
    }
    private void ensureWindowFits(){
        Container parent = this.getParent();
        while (parent.getParent() != null){
            parent = parent.getParent();
        }
        java.awt.Frame f = (java.awt.Frame)parent;
        f.pack();   
    }
    /** 
     * @see heurgame.event.PlayerListener#playerJoined(heurgame.event.PlayerEvent)
     */
    public void playerJoined(PlayerEvent arg0) {}

    /** 
     * @see heurgame.event.PlayerListener#playerLeft(heurgame.event.PlayerEvent)
     */
    public void playerLeft(PlayerEvent e) {
        if (e.disqualified){
            updateScore(e.player,0);
            updateActive(e.player,"DISQUALIFIED");
        }
    }

    /** 
     * @see heurgame.event.PlayerListener#playerMoved(heurgame.event.PlayerEvent)
     */
    public void playerMoved(PlayerEvent e) {
        if (e.validMove){
            if (activePart.get(e.player)==null){
                add(buildNewListing(e.player));
                Container parent = this.getParent();
                while (parent.getParent() != null){
                    parent = parent.getParent();
                }
                java.awt.Frame f = (java.awt.Frame)parent;
                f.pack();
            }
        }
    }

    /** 
     * @see heurgame.event.PlayerListener#playerStatusChanged(heurgame.event.PlayerEvent)
     */
    public void playerStatusChanged(PlayerEvent e) {
        //updateLabel(e.player,"",e.score,e.timeLeft);
        updateScore(e.player,e.score);
    }
    /** 
     * @see heurgame.event.TurnListener#turnChanged(heurgame.event.TurnEvent)
     */
    public synchronized void turnChanged(TurnEvent e) {
        java.util.Set s = activePart.keySet();
        java.util.Iterator i = s.iterator();
        synchronized(activePart){
            while(i.hasNext()){
                PlayerToken iplay = (PlayerToken)i.next();
                if (iplay == e.player){
                    updateActive(iplay,"turn");
                }else{
                    updateActive(iplay,"-");
                }
            }
        }
    }
    /** 
     * @see heurgame.event.GameListener#gameSetup(heurgame.event.GameEvent)
     */
    public void gameSetup(GameEvent e) {
    }
    /** 
     * @see heurgame.event.GameListener#gameStarted(heurgame.event.GameEvent)
     */
    public void gameStarted(GameEvent e) {     
    }
    /** 
     * @see heurgame.event.GameListener#gameEnded(heurgame.event.GameEvent)
     */
    public void gameEnded(GameEvent e) {
        java.util.Set s = scorePart.keySet();
        java.util.Iterator i = s.iterator();
        PlayerToken[] winners = e.context.getSystemAnalyzer().getWinningPlayers();
        while(i.hasNext()){
            PlayerToken iplay = (PlayerToken)i.next();
            for(int j=0;j<winners.length;j++){
                if (iplay==winners[j]){
                    if (e.context.getSystemAnalyzer().isDecisive()){
                        updateActive(iplay,"WON!");
                    }else{
                        updateActive(iplay,"Tied");
                    }
                }else{
                    updateActive(iplay,"Lost :(");
                }
            }
        }        
    }
}
