package nanomunchers.ui;

import heurgame.HuClient;
import heurgame.HuReceptor;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import nanomunchers.graph.KGraph;
/*
 * Created on Oct 30, 2004
 */

/**
 * @author David Kaplin
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class NanoInputFrame extends Frame implements HuReceptor {
    private List moveList;
    private NanoDecisionPanel nanoDecision;
    private HuClient contact;
    public void setGraph(KGraph board){
        nanoDecision.setGraph(board);
    }
    public NanoInputFrame(){
        nanoDecision = new NanoDecisionPanel();
        moveList = new List();
        moveList.add("Up");
        moveList.add("Left");
        moveList.add("Down");
        moveList.add("Right");
        Button raiseButton = new Button("Raise");
        Button lowerButton = new Button("Lower");
        Button sendMove = new Button("Send Move");
        raiseButton.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e) {
                int item = moveList.getSelectedIndex(); 
                if (item != -1 || item > 0){
                    String itemText = moveList.getItem(item);
                    moveList.remove(item);
                    moveList.add(itemText,item-1);
                    moveList.select(item-1);
                }
                
            }
        }
        );
        lowerButton.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e) {
                int item = moveList.getSelectedIndex(); 
                if ((item != -1) || 
                        (item < (moveList.getItemCount()-1))){
                    String itemText = moveList.getItem(item);
                    moveList.remove(item);
                    moveList.add(itemText,item+1);
                    moveList.select(item+1);
                }
            }
        }
        );
        sendMove.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e) {
                boolean chosePoint = nanoDecision.commitPoint();
                if (chosePoint==false){
                    return;
                }
                Point p = nanoDecision.getRecentPoint();
                StringBuffer moveText = new StringBuffer();
                moveText.append(p.x);
                moveText.append(" ");
                moveText.append(p.y);
                moveText.append(" ");
                for(int i=0;i<moveList.getItemCount();i++){
                    moveText.append(moveList.getItem(i).charAt(0));
                    if (i+1!=moveList.getItemCount()){
                        moveText.append(" ");                        
                    }
                }
                contact.fromOutside(""+moveText);
                hide();
            }
        }
        );
        setLayout(new BorderLayout());
        add(nanoDecision);
        Panel movePanel = new Panel();
        Panel moveButtonPanel = new Panel();
        moveButtonPanel.setLayout(new GridLayout(1,2,3,3));
        moveButtonPanel.add(raiseButton);
        moveButtonPanel.add(lowerButton);
        movePanel.setLayout(new BorderLayout());
        movePanel.add(moveButtonPanel,BorderLayout.NORTH);
        movePanel.add(sendMove,BorderLayout.SOUTH);
        movePanel.add(moveList);
        add(movePanel,BorderLayout.WEST);
        nanoDecision.setSize(500,400);
        setSize(500,400);
    }
    /** 
     * @see heurgame.HuReceptor#captureMove(heurgame.HuClient)
     */
    public void captureMove(HuClient h) {
        contact = h;
        this.setTitle(h.getName()+"'s Move");
        show();
    }
}
