package nanomunchers.ui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

import nanomunchers.graph.KEdge;
import nanomunchers.graph.KGraph;
import nanomunchers.graph.KGraphFactory;
import nanomunchers.graph.KNode;

/*
 * Created on Oct 26, 2004
 */

/**
 * @author David Kaplin
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class GraphEditPanel extends Canvas{
    private KGraph graph;
    Graphics bufferGraphics;
	Image offscreen;
	boolean[] edgesShown;
	Point[] midpoints;
	int hoffset,woffset;
	int lastWidth=-1;
	int lastHeight = -1;
	Vector chosenEdges = new Vector();
	Point mLocation = null;
	GraphDrawing graphDrawing = new GraphDrawing();
    public GraphEditPanel(){
        Thread paintThread = new Thread(){
            public void run(){
                while(true){
                try {
                    Thread.sleep(100);
                }catch (InterruptedException e){
                    
                }
                repaint();
                }
            }
        };
        paintThread.start();
        GridDragWatcher dragWatcher = new GridDragWatcher();
        addMouseListener(dragWatcher);
        addMouseMotionListener(dragWatcher);
    }
    public void loadGraph(KGraph inGraph){
        graph = KGraphFactory.buildGridGraph(inGraph.getWidth(),inGraph.getHeight());
        
        edgesShown = new boolean[graph.getUniqueEdges().length];
        midpoints = new Point[graph.getUniqueEdges().length];
        KNode[] originalNodes = inGraph.getNodes();
        KEdge[] originalEdges = inGraph.getUniqueEdges();
        KEdge[] currentEdges = graph.getUniqueEdges();
        for(int i=0;i<edgesShown.length;i++){
            boolean showIt = false;
            for(int j=0;j<originalEdges.length;j++){
                if (originalEdges[j].equalsSpacially(currentEdges[i])){
                    showIt = true;
                    break;
                }
            }
            edgesShown[i]=showIt;
        }
        //now let
        graphDrawing.setGraph(graph);
    }
    public KGraph getGraph(){
        if (graph==null){
            return null;
        }
        KNode[] nodes = graph.getNodes();
        KEdge[] originalEdges = graph.getUniqueEdges();
        Vector edgeVector = new Vector();
        for(int i=0;i<edgesShown.length;i++){
            if (edgesShown[i]){
                edgeVector.add(originalEdges[i]);
            }
        }
        KEdge[] finalEdges = new KEdge[edgeVector.size()];
        for(int i=0;i<edgeVector.size();i++){
            finalEdges[i] = (KEdge) edgeVector.get(i);
        }
        return KGraphFactory.buildFromParts(nodes,finalEdges);
    }
    public void paint(Graphics g){
        update(g);
    }
    public void update(Graphics g){
        if (graph==null){
            g.drawString("No Graph Loaded",10,10);
            return;
        }
        int width = getWidth();
        int height = getHeight();
        if (offscreen == null || (width != lastWidth) || (height != lastHeight)) {
			offscreen = createImage(width, height);
			bufferGraphics = offscreen.getGraphics();
		}
        lastWidth = width;
        lastHeight = height;
        bufferGraphics.setColor(Color.BLACK); 
		bufferGraphics.fillRect(0, 0, width, height);
        
        //g.translate(0,-1);
        woffset = width/(graph.getWidth()+1);
        hoffset = height/(graph.getHeight()+1);
        bufferGraphics.setColor(Color.GRAY);
        graphDrawing.drawGraph(bufferGraphics,Color.GRAY,width,height);
        if (((width+1) > graph.getWidth()) && ((height+1) > graph.getHeight())){
            KEdge[] edges = graph.getUniqueEdges();
            int sx,sy,dx,dy;
            for(int i=0;i<edges.length;i++){
                g.setColor(Color.LIGHT_GRAY);
                if (edgesShown[i]){
                    graphDrawing.highlightEdge(bufferGraphics,Color.LIGHT_GRAY,edges[i],4);
                 }
                sx = woffset + woffset*edges[i].getNodes()[0].getX();
                dx = woffset + woffset*edges[i].getNodes()[1].getX();
                sy = hoffset + hoffset*edges[i].getNodes()[0].getY();
                dy = hoffset + hoffset*edges[i].getNodes()[1].getY();
                if (chosenEdges.indexOf(new Integer(i))!= -1){
                    graphDrawing.drawEdge(bufferGraphics,Color.CYAN,edges[i],3);
                }
                    midpoints[i] = new Point((sx+dx)/2,(sy+dy)/2);
                
            }
        }
        if (mLocation != null){
            bufferGraphics.setColor(Color.WHITE);
            bufferGraphics.drawString("("+mLocation.x+","+mLocation.y+")",10,10);
        }
        //g.translate(0,1);
        g.drawImage(offscreen, 0, 0, this);
    }
    public static void main(String args[]){
        final Frame f = new Frame("Graph Editor");
        f.setLayout(new java.awt.BorderLayout());
        GraphEditPanel gep = new GraphEditPanel();
        
        gep.setSize(500,350);
        f.add(gep);
        
        f.addWindowListener(new WindowAdapter(){
            public void windowClosing(WindowEvent e){
                f.dispose();
                System.exit(1);
            }
        });
        f.pack();
        f.show();
    }
    class GridDragWatcher extends MouseAdapter implements MouseMotionListener{
        private boolean dragStarted = false;
        private int sx = -1;
        private int sy = -1;
        public void mouseReleased(MouseEvent e){
            
            for(int i=0;i<chosenEdges.size();i++){
                Integer place = (Integer)chosenEdges.get(i);
                edgesShown[place.intValue()] = !edgesShown[place.intValue()];
            }
            chosenEdges.clear();
        }

        /** 
         * @see java.awt.event.MouseMotionListener#mouseDragged(java.awt.event.MouseEvent)
         */
        public void mouseDragged(MouseEvent e) {
            int ex = e.getX();
            int ey = e.getY();
            sx = ex;
            sy = ey;
            int closest = -1;
            double bestdist = 10000;
            for(int i=0;i<midpoints.length;i++){
                Point p = midpoints[i];
                int dx = (ex> p.x) ? ex - p.x : p.x - ex;
                int dy = (ey> p.y) ? ey - p.y : p.y - ey;
                double dist = Math.sqrt(dx*dx +dy*dy);
                if (dist < bestdist){
                    closest = i;
                    bestdist = dist;
                }
            }
            Integer possible = new Integer(closest);
            if (bestdist < 10 && chosenEdges.indexOf(possible)==-1){
            //edgesShown[closest] = !edgesShown[closest];
                chosenEdges.add(possible);
            }
            //repaint();
            //edgesShown[x + y*graph.getWidth()] = !edgesShown[x + y*graph.getWidth()]; 
        }

        /** 
         * @see java.awt.event.MouseMotionListener#mouseMoved(java.awt.event.MouseEvent)
         */
        public void mouseMoved(MouseEvent e) {
            if (woffset==0 || hoffset==0) return;
            int ex = e.getX();
            int ey = e.getY();
            ex = (ex-woffset/2)/woffset;
            ey = (ey-hoffset/2)/hoffset;
            if (((ex >= 0) && (ex < getWidth())) &&
                    ((ey >= 0) && (ey < getHeight()))){
                mLocation = new Point(ex,ey);
            }
        }
    }
    
}
