package nanomunchers.ui;

import java.awt.Graphics;
import java.awt.Color;

import nanomunchers.graph.KEdge;
import nanomunchers.graph.KGraph;

/*
 * Created on Oct 30, 2004
 */

/**
 * @author David Kaplin
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class GraphDrawing {
    int hoffset,woffset;
    int width;
    int height;
	private KGraph graph;
	public void setGraph(KGraph g){
	    graph = g;
	}
	public void drawGraph(Graphics g,Color c,int width,int height){
	    g.setColor(c);
	    woffset = width/(graph.getWidth()+1);
        hoffset = height/(graph.getHeight()+1);
	    if (((width+1) > graph.getWidth()) && ((height+1) > graph.getHeight())){
            KEdge[] edges = graph.getUniqueEdges();
            int sx,sy,dx,dy;
            for(int i=0;i<edges.length;i++){
                drawEdge(g,c,edges[i],1);
            }
	    }
	}
	public void drawEdge(Graphics g, Color c, KEdge e, int thickness){
	    g.setColor(c);
	    int sx = woffset + woffset*e.getNodes()[0].getX();
        int dx = woffset + woffset*e.getNodes()[1].getX();
        int sy = hoffset + hoffset*e.getNodes()[0].getY();
        int dy = hoffset + hoffset*e.getNodes()[1].getY();
        g.drawLine(sx,sy,dx,dy);
        for(int t=0;t<(thickness/2);t++){
            g.drawLine(sx+t,sy,dx+t,dy);
            g.drawLine(sx-t,sy,dx-t,dy);
            g.drawLine(sx,sy+t,dx,dy+t);
            g.drawLine(sx,sy-t,dx,dy-t);
        }
	}
	public void highlightEdge(Graphics g, Color c, KEdge e, int thickness){
	    g.setColor(c);
	    drawEdge(g,c,e,thickness);
	    int nanoRad = (width < height) ? woffset/2 : hoffset/2;
	    
	    nanoRad/=3;
	    
	    int sx = woffset + woffset*e.getNodes()[0].getX();
        int dx = woffset + woffset*e.getNodes()[1].getX();
        int sy = hoffset + hoffset*e.getNodes()[0].getY();
        int dy = hoffset + hoffset*e.getNodes()[1].getY();
	    g.drawOval(dx-(nanoRad-1),dy-(nanoRad-1),2*(nanoRad-1),2*(nanoRad-1));
        g.drawOval(sx-(nanoRad-1),sy-(nanoRad-1),2*(nanoRad-1),2*(nanoRad-1));
	}
	public void drawBotAlive(Graphics g,Color c, int x, int y,int nextX, int nextY){
	    g.setColor(c);
	    int nanoRad = (width < height) ? woffset/2 : hoffset/2;
	    if (nanoRad> 2){
	        nanoRad-=2;
	    }
	    g.fill3DRect(x-nanoRad/2,y-nanoRad/2,nanoRad,nanoRad,true);
	    g.setColor(new Color(255,255,255));
	//    g.fillOval(nextX-(nanoRad/2),nextY-(nanoRad/2),nanoRad,nanoRad);
	    g.fillOval(nextX-(nanoRad/3),nextY-(nanoRad/3),2*(nanoRad/3),2*(nanoRad/3));
	}
	public void drawBotDead(Graphics g,Color c, int x, int y,int nextX, int nextY){
	    g.setColor(c);
	    int nanoRad = (width < height) ? woffset/2 : hoffset/2;
	    if (nanoRad> 2){
	        nanoRad-=2;
	    }
	    g.fill3DRect(x-nanoRad/2,y-nanoRad/2,nanoRad,nanoRad,false);
	    g.setColor(new Color(255,255,255));
//	    g.fillOval(nextX-(nanoRad/2),nextY-(nanoRad/2),nanoRad,nanoRad);
	    g.fillOval(nextX-(nanoRad/3),nextY-(nanoRad/3),2*(nanoRad/3),2*(nanoRad/3));
	}
	public void drawBotSlain(Graphics g,Color c, int x, int y,int nextX, int nextY){
	    int nanoRad = (width < height) ? woffset/2 : hoffset/2;
	    if (nanoRad> 2){
	        nanoRad-=2;
	    }
	    g.setColor(c);
	    g.fill3DRect(x-nanoRad/2,y-nanoRad/2,nanoRad,nanoRad,false);
	    g.setColor(new Color(0,0,0));
	    g.fillOval(nextX-(nanoRad/3),nextY-(nanoRad/3),2*(nanoRad/3),2*(nanoRad/3));
	}
}
