package nanomunchers;

import java.io.IOException;

import heurgame.HuClient;
/*
 * Created on Oct 21, 2004
 */

/**
 * @author David Kaplin
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class NanoHuClient extends HuClient {
    private volatile boolean needRun = true;
    private volatile String lastMove;

    /** 
     * @see heurgame.HuClient#waitForMessage()
     */
    public String waitForMessage() {
        try {
            String msg = this.fromServer.readLine();
            int spacePosition = msg.indexOf(" ");
            
            String cmd = "";
            if (spacePosition> 0){
                cmd = msg.substring(0,spacePosition);
                msg = msg.substring(msg.indexOf(" ")+1,msg.length());
            }
            if (msg.equals("DONE")){
                //do nothing really
            }else if (msg.equals("NEXT")){
                lastMove = handleMove(msg);
                toServer.println(lastMove);
                toServer.flush();
            }else if (cmd.equals("MOVE")){
                lastMove = handleMove(msg);
                toServer.println(lastMove);
                toServer.flush();
            }else if (cmd.equals("INIT")){
                handleInitialStatus(msg);
            }else if (cmd.equals("FINAL")){
                handleFinalStatus(msg);
            }else if (cmd.equals("INVALID")){
                lastMove = handleMove(msg);
                toServer.println(lastMove);
                toServer.flush();
            }else if (cmd.equals("OUTTAHERE")){
                handleDisqualification(msg);
            }
        } catch (IOException e) {
            debugging.addUrgentEntry("Protocol Cracker",e.getLocalizedMessage(), 1);
            needRun = false;
        }
        return null;
    }

    /** 
     * @see heurgame.HuClient#handleMove(java.lang.String)
     */
    public String handleMove(String query) {
        guiReceptor.captureMove(this);
        while(this.move.length()==0){
            if (needRun==false){
                break;
            }
            try {
                Thread.sleep(150);
            }catch (InterruptedException e){
                e.printStackTrace();
            }
        }
        String response = new String(this.move);
        this.move = "";
        debugging.addEntry("Move","Sent "+response);
        return response;
    }

    /** 
     * @see heurgame.HuClient#handleInvalidMove(java.lang.String)
     */
    public String handleInvalidMove(String reason) {
        guiReceptor.captureMove(this);
        while(this.move.length()==0){
            try {
                if (needRun==false){
                    break;
                }
                Thread.sleep(50);
            }catch (InterruptedException e){
                e.printStackTrace();
            }
        }
        String response = new String(this.move);
        this.move = "";
        debugging.addEntry("Invalid Move","Sent "+response);
        return response;
    }

    /** 
     * Can be ignored
     * @see heurgame.HuClient#handleInitialStatus(java.lang.String)
     */
    public void handleInitialStatus(String status) { }

    /**
     * Not used 
     * @see heurgame.HuClient#handleStatus(java.lang.String)
     */
    public void handleStatus(String status) {   }

    /** 
     * Not used
     * @see heurgame.HuClient#handleIncrementalStatus(java.lang.String)
     */
    public void handleIncrementalStatus(String status) {    }

    /** 
     * @see heurgame.HuClient#handleFinalStatus(java.lang.String)
     */
    public void handleFinalStatus(String status) {
        debugging.addEntry("Final status ",status);
        toServer.close();
        try {
            fromServer.close();
        } catch (IOException e) {
            debugging.addUrgentEntry("Final Status",e.getLocalizedMessage(), 1);
        }
        needRun = false;
    }

    /** 
     * @see heurgame.HuClient#handleDisqualification(java.lang.String)
     */
    public void handleDisqualification(String reason) {
        debugging.addEntry("Disqualified","Reason "+reason);
        needRun = false;
        try {
            fromServer.close();
        } catch (IOException e1) {
            // TODO Auto-generated catch block
            e1.printStackTrace();
        }
        toServer.close();
        try {
            fromServer.close();
        } catch (IOException e) {
            debugging.addUrgentEntry("Disqualified",e.getLocalizedMessage(), 1);
        }
        
    }

    /** 
     * @see java.lang.Runnable#run()
     */
    public void run() {
        while(needRun == true){
            try {
                Thread.sleep(50);
                if (fromServer != null && toServer != null){
                	waitForMessage();
                }
            }catch (InterruptedException e){
                e.printStackTrace();
            }
        }
    }

}
