package heurgame.ui;

import java.awt.Label;
import java.text.SimpleDateFormat;

import heurgame.PlayerToken;
import heurgame.event.GameEvent;
import heurgame.event.GameListener;
import heurgame.event.TimeEvent;
import heurgame.event.TimeListener;
/*
 * Created on Oct 15, 2004
 */

/**
 * @author David Kaplin
 *
 */
public class EstimatedTime implements TimeListener, GameListener {
    private Label output = new Label();
    private PlayerToken specificPlayer;
    
    public Label getEstimatedTime(){
        output.setSize(100,50);
        return output;
    }
    public EstimatedTime(){
        specificPlayer = null;
    }
    public EstimatedTime(PlayerToken t){
        specificPlayer = t;
    }
    /** 
     * @see heurgame.event.GameListener#gameSetup(heurgame.event.GameEvent)
     */
    public void gameSetup(GameEvent e) { }

    /** 
     * @see heurgame.event.GameListener#gameStarted(heurgame.event.GameEvent)
     */
    public void gameStarted(GameEvent e) { }

    /** 
     * @see heurgame.event.GameListener#gameEnded(heurgame.event.GameEvent)
     */
    public void gameEnded(GameEvent e) {
        output.setText("Game Over");
    }
    /** 
     * @see heurgame.event.TimeListener#timeChanged(heurgame.event.TimeEvent)
     */
    public void timeChanged(TimeEvent t) {
        SimpleDateFormat f = new SimpleDateFormat("mm:ss:SSS");
        if (t.totalTimeRemaining > 0){
            String timeStr = " Normal ["+f.format(new java.util.Date(t.normalTimeRemaining))+"]";
            if (t.normalTimeRemaining==0){
                timeStr = " Extra [" + f.format(new java.util.Date(t.totalTimeRemaining))+"]";
            }
            output.setText(t.who.getName()+": "+timeStr);
        }else{
            output.setText(t.who.getName()+": TIME UP");
        }
    }

}
