package nanomunchers.ui;

import heurgame.ui.DisplayUtilities;
import heurgame.ui.builder.ComponentOrientedBuilder;
import heurgame.ui.builder.MutableTextWrapper;
import heurgame.ui.builder.ZeroLayoutBuilder;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;

import nanomunchers.graph.Graph;
import nanomunchers.graph.GraphFactory;

/*
 * Created on Oct 29, 2004
 */

/**
 * The Outer shell of the GraphEditor.
 * 
 * @author David Kaplin
 */
public class GraphEditor {
    private GraphGeneration generator;
    private GraphEditPanel editPanel;
    private Component fileLabel;
    private String fileDestination = null;
    private int mainFrameHandle;
    private FileDialog saveWindow;
    private Frame parent;
    private ComponentOrientedBuilder aBuilder;
    
    /**
     * Creates a new GraphEditor
     * 
     * @param previous Window to be closed when this one opens
     * @param cBuilder used to extract the correct sort of widgets
     */
    public GraphEditor(Frame previous,ComponentOrientedBuilder cBuilder){
        aBuilder = cBuilder;
        parent = previous;
        mainFrameHandle = aBuilder.buildScreen("Nanomunchers Graph Editor");
        aBuilder.getScreen(mainFrameHandle).addWindowListener(new WindowAdapter(){
            public void windowClosing(WindowEvent w){
                aBuilder.getScreen(mainFrameHandle).dispose();
                parent.show();
            }
        });
        editPanel = new GraphEditPanel();
        editPanel.setSize(400,400);
        generator = new GraphGeneration(cBuilder);
        //mainFrame.setLayout(new BorderLayout());
        int fileLabelHandle = aBuilder.buildTextDisplay("Save to: ");
        fileLabel = aBuilder.getComponent(fileLabelHandle);
        int generateHandle =aBuilder.buildAction("Generate Graph", new Runnable(){
            public void run(){
                if (generator.generateGraph()==false){
                    return;
                }
                Graph built = generator.getGraph();
                editPanel.loadGraph(built);                        
            }
        }); 
        Component generate = aBuilder.getComponent(generateHandle);
        int saveButtonHandle = aBuilder.buildAction("Save",new Runnable(){
            public void run(){
                MutableTextWrapper fileLabelText = new MutableTextWrapper(fileLabel);
                if (editPanel.getGraph()!=null && fileDestination != null){
        	        try {
                        GraphFactory.saveFile(fileDestination, editPanel.getGraph());
                    } catch (IOException e1) {
                        
                        fileLabelText.setText("Save Error" + e1);
                        return;
                    }
        	        fileLabelText.setText("Saved");
        	    }else{
        	        fileLabelText.setText("No file specified");
        	    }
            }   
        }
                
        );
        int saveAsButtonHandle = aBuilder.buildAction("Save As...",new Runnable(){
            public void run(){
                MutableTextWrapper fileLabelText = new MutableTextWrapper(fileLabel);
                saveWindow = new FileDialog(aBuilder.getScreen(mainFrameHandle), "Save As", FileDialog.SAVE);
        	    saveWindow.show();
        	    if (saveWindow.getDirectory() !=null){
        	        String filename = saveWindow.getDirectory() + saveWindow.getFile();
        	        fileDestination = filename;
        	        if (editPanel.getGraph()!=null && fileDestination != null){
            	        try {
                            GraphFactory.saveFile(fileDestination, editPanel.getGraph());
                        } catch (IOException e1) {
                            fileLabelText.setText("Save Error" + e1);
                            return;
                        }
            	        fileLabelText.setText("Saved to: "+ filename);
            	    }else{
            	        fileLabelText.setText("No file specified");
            	    }
        	    }
        	    DisplayUtilities.ensureWindowFits(fileLabel);                    
            }   
        }
                
     );
        ZeroLayoutBuilder zBuilder = new ZeroLayoutBuilder(cBuilder);
        int northRegion = aBuilder.buildRegion("north");
        zBuilder.startRegion(northRegion);
        zBuilder.setRightRegion(aBuilder.buildWrappedComponent(generate));
        zBuilder.setMainRegion(aBuilder.buildWrappedComponent(generator));
        zBuilder.finishRegion(northRegion);
        
        
        int southRegion = aBuilder.buildRegion("south");
        int saveButtonRegion = aBuilder.buildRegion("save");
        zBuilder.startRegion(saveButtonRegion);
        zBuilder.addToCommands(saveAsButtonHandle);
        zBuilder.addToCommands(saveButtonHandle);
        zBuilder.finishRegion(saveButtonRegion);
        
        zBuilder.startRegion(southRegion);
        zBuilder.setMainRegion(fileLabelHandle);
        zBuilder.setRightRegion(saveButtonRegion);
        zBuilder.finishRegion(southRegion);
        
        zBuilder.startRegion(mainFrameHandle);
        zBuilder.setTopRegion(northRegion);
        zBuilder.setMainRegion(aBuilder.buildWrappedComponent(editPanel));
        zBuilder.setBottomRegion(southRegion);
        zBuilder.finishRegion(mainFrameHandle);
        
        aBuilder.getScreen(mainFrameHandle).setSize(400,400);
    }
    /**
     * Does a little more than the standard show method.
     * Hides the parent and centers this window.
     */
    public void show(){
        parent.hide();
        Frame f = aBuilder.getScreen(mainFrameHandle);
        DisplayUtilities.packAndCenterWindow(f);
        f.show();
        generator.setMode(GraphGeneration.GRAPH_COMPLETE);
    }
}
