package nanomunchers.graph;

import java.awt.Point;

/*
 * Created on Oct 26, 2004
 */

/**
 * A single node in a graph.
 * 
 * @author David Kaplin
 */
public class Node {
    private int id;
    private boolean marked;
    private Point gridPosition;
    private Graph parent;
    /**
     * @param owner for the node to know other nodes and edges
     * @param id internal id
     * @param x virtual position
     * @param y virtual position
     */
    public Node(Graph owner,int id, int x, int y){
        this.id = id;
        gridPosition = new Point(x,y);
        parent = owner;
    }
    /**
     * @return internal id
     */
    public int getId(){
        return id;
    }
    /**
     * @return virtual screen position
     */
    public int getX(){
        return gridPosition.x;
    }
    /**
     * @return point representation of virtual screen position
     */
    public Point getPoint(){
        return gridPosition;
    }
    /**
     * @return virtual screen position
     */
    public int getY(){
        return gridPosition.y;
    }
    /**
     * Marks the node
     */
    public void mark(){
        marked=true;
    }
    /**
     * @return true if marked.
     */
    public boolean isMarked(){
        return marked;
    }
    /**
     * Removes marking
     */
    public void clear(){
        marked=false;
    }
    /** 
     * Descriptive string about the node
     * @see java.lang.Object#toString()
     */
    public String toString(){
        return ""+id +" "+ gridPosition.x+" "+gridPosition.y;
    }
    /**
     * @return all neighbors of this node
     */
    public Node[] getNeighbors(){
        Edge[] paths = parent.getNeighbors(this);
        Node[] others = new Node[paths.length];
        for(int p=0;p<paths.length;p++){
           others[p] = paths[p].getOther(this); 
        }
        return others;
    }
    /**
     * @return that owns this node.
     */
    public Graph getGraph(){
        return parent;
    }
}
