package nanomunchers.graph;
/*
 * Created on Oct 26, 2004
 */

/**
 * @author David Kaplin
 *
 */
public interface Graph {
    /**
     * @return the nodes that make up a graph.
     */
    public Node[] getNodes();
    /**
     * @return if the graph contians bi-directional edges return only
     * (A,B) as opposed to (A,B) and (B,A)
     */
    public Edge[] getUniqueEdges();
    /**
     * @return Subgraphs that are strongly connected.
     */
    public Graph[] getConnectedComponents();
    /**
     * @return largest span of nodes in width
     */
    public int getWidth();
    /**
     * @return largest span of nodes in height
     */
    public int getHeight();
    /**
     * Clears any marked nodes on the graph.
     */
    public void clear();
    /**
     * @param n node to start at 
     */
    public Edge[] getNeighbors(Node n);
}
