package nanomunchers.event;
/*
 * Created on Dec 10, 2004
 */

/**
 * Listens to notifications of the playing or creation of Frames 
 *
 * @author David Kaplin
 *
 */
public interface FrameListener {
    /**
     * Called when frames are created.
     * 
     * @param totalFrames is the total number of frames known to exist now.
     */
    public void frameCreated(int totalFrames);
    /**
     * Called when a frame is being played.
     * 
     * @param currentFrame being played
     * @param totalFrames in the entire playback.
     */
    public void frameStarted(int currentFrame, int totalFrames);
}
