package nanomunchers;

import java.io.IOException;

import heurgame.PlayerProxy;
import heurgame.logging.LogBox;
/*
 * Created on Oct 21, 2004
 */

/**
 * The Server-side of the nanomunchers protocol.
 * 
 * @author David Kaplin
 */
public class NanoPlayerProxy extends PlayerProxy {

    /** 
     * Issues "MOVE" request
     * @see heurgame.PlayerProxy#getMove(java.lang.String)
     */
    public String getMove(String query) {
        this.toPlayer.println("MOVE "+query);
        this.toPlayer.flush();
        this.debugging.addEntry("Move sent","sent "+query);
        String response = new String();
        try {
            response = fromPlayer.readLine();
        } catch (IOException e) {
            this.debugging.addEntry("Move sent problem ","execption "+e.getLocalizedMessage());
        }
        return response;
    }

    /** 
     * Issues "OUTTAHERE"
     * @see heurgame.PlayerProxy#sendDisqualify(java.lang.String)
     */
    public void sendDisqualify(String reason) {
        this.toPlayer.println("OUTTAHERE "+reason);
        this.toPlayer.flush();
        this.debugging.addEntry("Disqualified","sent "+reason);
    }

    /** 
     * Issues "INIT" with initial protocol information
     * @see heurgame.PlayerProxy#sendInitialStatus(java.lang.String)
     */
    public void sendInitialStatus(String status) {
        this.toPlayer.println("INIT "+status);
        this.toPlayer.flush();
        this.debugging.addEntry("INIT","sent "+status);
    }

    /** 
     * Issues "FINAL" WIN, LOSE, TIE
     * @see heurgame.PlayerProxy#sendFinalStatus(java.lang.String)
     */
    public void sendFinalStatus(String status) {
        this.toPlayer.println("FINAL "+status);
        this.toPlayer.flush();
        this.debugging.addEntry("FINAL","sent "+status);
    }

    /** 
     * Not needed
     * @see heurgame.PlayerProxy#sendStatus(java.lang.String)
     */
    public void sendStatus(String status) { }

    /**
     * Not needed 
     * @see heurgame.PlayerProxy#sendIncrementalStatus(java.lang.String)
     */
    public void sendIncrementalStatus(String status) {}

    /** 
     * Issues "INVALID"
     * @see heurgame.PlayerProxy#sendInvalidMove(java.lang.String)
     */
    public String sendInvalidMove(String information) {
        this.toPlayer.println("INVALID "+information);
        this.toPlayer.flush();
        this.debugging.addEntry("INVALID","sent "+information);
        String response = new String();
        try {
            response = fromPlayer.readLine();
        } catch (IOException e) {
            //e.printStackTrace();
            this.debugging.addUrgentEntry("INVALID","response "+e.getLocalizedMessage(),1);
        }
        return response;
    }

    /** 
     * @see heurgame.PlayerProxy#setupLogging(heurgame.logging.LogBox)
     */
    public void setupLogging(LogBox debugger) {
        this.debugging = debugger;
    }

    /** 
     * Issues "WARNING" milliseconds
     * @see heurgame.PlayerProxy#sendWarning(java.lang.String)
     */
    public void sendWarning(String information) {
        this.toPlayer.println("WARNING "+information);
        this.toPlayer.flush();
        this.debugging.addEntry("WARNING","sent "+information);
    }
    
    /**
     * Issues "NEXT"
     * @return player response
     */
    public String sendNext(){
        this.toPlayer.println("NEXT");
        this.toPlayer.flush();
        this.debugging.addEntry("NEXT","sent");
        String response = new String();
        try {
            response = fromPlayer.readLine();
        } catch (IOException e) {
            //e.printStackTrace();
            this.debugging.addUrgentEntry("NEXT","response "+e.getLocalizedMessage(),1);
        }
        return response;
    }
    /**
     * Issues "DONE"
     */
    public void sendDone(){
        this.toPlayer.println("DONE");
        this.toPlayer.flush();
        this.debugging.addEntry("DONE","sent");
    }
}
