#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <assert.h>

int seqExt, seqlen, numseqs, padBefore, padAfter;
char name[1024], **seqs;

int getLength (char *filename){
  FILE *file;
  char buffer[1024], ch;
  int length = 0;

  file = fopen (filename, "r"); assert (file);
  fgets (buffer, 1024, file);
  while (!feof (file)){
    ch = fgetc (file);
    if (ch == '>') break;
    if (isalpha (ch) || ch == '.' || ch == '-') length++;
  }
  fclose (file);

  return length;
}

void readfile (char *filename){
  FILE *file;
  char buffer[1024], ch;
  int i;

  numseqs = 0;
  seqlen = getLength (filename);
  strcpy (name, "");
  seqs = (char **) malloc (sizeof (char *) * 1); assert (seqs);
  seqs[0] = (char *) malloc (sizeof (char) * seqlen);

  file = fopen (filename, "r"); assert (file);
  while (!feof (file)){
    i = 0;
    fgets (buffer, 1024, file);
    if (strlen (name) == 0) strcpy (name, buffer);
    if (feof (file)) break;
    numseqs++;
    if (numseqs > 1){
      seqs = (char **) realloc (seqs, sizeof (char *) * numseqs); assert (seqs);
      seqs[numseqs - 1] = (char *) malloc (sizeof (char) * seqlen); assert (seqs[numseqs - 1]);
    }
        
    while (!feof (file)){
      ch = tolower(fgetc (file));
      if (ch == '>') break;
      if (isalpha (ch) || ch == '.' || ch == '-'){
	assert (i < seqlen);
	seqs[numseqs - 1][i] = ch;
	i++;
      }
    }
    if (ch == '>') ungetc (ch, file);
    assert (i == seqlen);
  }
  fclose (file);
}

void print (void){
  int i = 0, written = 0;

  assert (seqExt >= 0 && seqExt < numseqs);
  printf ("%s", name);

  for (i = 0; i < seqlen; i++){
    if (seqs[seqExt][i] == seqs[0][i]){
      seqs[seqExt][i] = toupper (seqs[seqExt][i]);
    }
  }

  fprintf (stderr, ">>>>>>>>>>>>>>>>>> %d %d %d\n", padBefore, seqlen, padAfter);

  for (i = 0; i < padBefore; i++){ printf ("-"); written++; if (written % 60 == 0) printf ("\n"); }
  for (i = 0; i < seqlen; i++){ printf ("%c", seqs[seqExt][i]); written++; if (written % 60 == 0) printf ("\n"); }
  for (i = 0; i < padAfter; i++){ printf ("-"); written++; if (written % 60 == 0) printf ("\n"); }
  if (written % 60 != 0) printf ("\n");
}

int main (int argc, char** argv){
  int i;

  if (argc != 5){
    fprintf (stderr, "Usage:\n\nfextract multi_fasta_file seqextract padbefore padafter\n");
    exit (1);
  }

  seqExt = atoi (argv[2]);
  padBefore = atoi (argv[3]);
  padAfter = atoi (argv[4]);

  readfile (argv[1]);
  print ();

  for (i = 0; i < numseqs; i++) free (seqs[i]);
  free (seqs);
}






