#!/usr/bin/env perl
use File::Basename;

$lazyflag = 0;
$lagandir = $ENV{LAGAN_DIR};
$recurfl = "-recurse \"(12,0,25),(13,1,25),(3,0,10)t,(8,1,30),(7,1,25),(7,1,15)\"";
$laganparams = "-gs -80 -gc -2 -mt 12 -ms -4 -maskedonly";
$laganparams = "-gs -80 -gc -2 -mt 12 -ms -4 -maskedonly -ext 100";
$anchgapstart = 0;
$anchgapcont = -0.04;
$anchgapcont = -0.1;
$usebounds = 1;
$startingrate = 40;
$rateinc = 1;
$pid = $$;

if (@ARGV < 2) {
    if ((@ARGV == 1) && ($ARGV[0] =~ /-version/)){
	print STDERR "DRAFT version 0.1\n";
	exit (0);
    }
    else {
	print STDERR ("Usage:\n\ndraft.pl SEQFILE MFAFILE [-cons RATE] [-translate] [-version]\n");
	exit (1);
    }
}

$ARGV[0] = "$ARGV[0].masked" if (-e "$ARGV[0].masked");
$ARGV[1] = "$ARGV[1].masked" if (-e "$ARGV[1].masked");

$arglist = "";
$skipfr = 0;
for ($i = 2; $i < @ARGV; $i++) {
    if ($ARGV[$i] =~ /-recurse/){
	$recurfl = " -recurse \"".$ARGV[++$i]."\"";
    }
    elsif ($ARGV[$i] =~ /-skipfr/){
	$skipfr = 1;
	$pid = $ARGV[++$i];
	chomp $pid;
    }
    elsif ($ARGV[$i] =~ /-translate/){
	$recurfl = $recurfl." -translate";
    }
    elsif ($ARGV[$i] =~ /-cons/){
	$startingrate = $ARGV[++$i];
	chomp $startingrate;
    }
    else {
	$arglist = $arglist." ".$ARGV[$i];
	if ($ARGV[$i] =~ /-lazy/){
	    $lazyflag = 1;
	}
    }
}

$arglist = "$arglist $recurfl -usebounds $laganparams";

# create new directory
$newdir = `pwd`;
chomp $newdir;
$newdir = "$newdir/$pid";
`mkdir $newdir` if (!(-e $newdir));

open (LOGFILE, ">$newdir/log");

print STDERR ("\n");
print STDERR ("Finding Contig Alignments\n");
print STDERR ("-------------------------\n");

print LOGFILE ("\n");
print LOGFILE ("Finding Contig Alignments\n");
print LOGFILE ("-------------------------\n");

# extract contigs;
$contigfile = basename ($ARGV[1]);
$contigdir = dirname ($ARGV[1]);

`cp $ARGV[1] $newdir`;
if (index ($ARGV[1], ".masked") != -1){
    $filename = substr $ARGV[1], 0, (rindex $ARGV[1], ".");
    `cp $filename $newdir` if (-e $filename);
}
@contigs = `perl $lagandir/mextract.pl $newdir/$contigfile`;
for ($i = 0; $i < @contigs; $i++){
    chomp $contigs[$i];
    `$lagandir/utils/rc < $contigs[$i] > $contigs[$i].rc`;
}

# create file storing name of contig stats
open (LFILE, ">$newdir/filenames") if (!$lazyflag);
$num = 0;

for ($i = 0; $i < @contigs; $i++){
    chomp $contigs[$i];

    # make alignments
    if (!$lazyflag || !(-e "$contigs[$i].mfa")){
	$execute = "perl $lagandir/lagan.pl $ARGV[0] $contigs[$i] -mfa $arglist -out $contigs[$i].mfa";
	$execute = $execute." -gap $anchgapstart $anchgapcont" if ($usebounds);
	`$execute`;

	if ($usebounds){
	    # compute bounds
	    @bounds = `$lagandir/utils/getbounds anchs.final $ARGV[0] $contigs[$i]`;
	    $bounds[0] =~ /-s1 (\d+) (\d+) -s2 (\d+) (\d+)/;
	    $s1shift = $1 - 1;
	}
	`rm anchs.final`;
    }

    if (!$lazyflag || !(-e "$contigs[$i].rc.mfa")){
	$execute = "perl $lagandir/lagan.pl $ARGV[0] $contigs[$i].rc -mfa $arglist -out $contigs[$i].rc.mfa";
	$execute = $execute." -gap $anchgapstart $anchgapcont" if ($usebounds);
	`$execute`;

 	if ($usebounds){
	    # compute bounds
	    @bounds = `$lagandir/utils/getbounds anchs.final $ARGV[0] $contigs[$i].rc`;
	    $bounds[0] =~ /-s1 (\d+) (\d+) -s2 (\d+) (\d+)/;
	    $s1rcshift = $1 - 1;
	}
	`rm anchs.final`;
    }

    $fscore = `$lagandir/utils/scorealign $contigs[$i].mfa $startingrate`; chomp $fscore;
    $bscore = `$lagandir/utils/scorealign $contigs[$i].rc.mfa $startingrate`; chomp $bscore;
    
    # pick strand

#    print LFILE "$s1shift $contigs[$i].mfa\n" if (!$lazyflag);
#    print LFILE "$s1rcshift $contigs[$i].rc.mfa\n" if (!$lazyflag);
    
#    if (0){
    if ($fscore > 0 || $bscore > 0){
	$j = $i + 1;
	if ($fscore > $bscore){
	    print STDERR ("(+) direction preferred for Contig \"$contigs[$i]\": $fscore > $bscore\n");
	    print LOGFILE ("(+) direction preferred for Contig \"$contigs[$i]\": $fscore > $bscore\n");
	    print LFILE "$j $s1shift $contigs[$i].mfa\n" if (!$lazyflag);
	}
	elsif ($bscore > $fscore){
	    print STDERR ("(-) direction preferred for Contig \"$contigs[$i]\": $fscore < $bscore\n");
	    print LOGFILE ("(-) direction preferred for Contig \"$contigs[$i]\": $fscore < $bscore\n");
	    print LFILE "$j $s1rcshift $contigs[$i].rc.mfa\n" if (!$lazyflag);
	}
    }
#    }
    else {
	print STDERR ("Contig \"$contigs[$i]\" could not be matched: $fscore, $bscore\n");
	print LOGFILE ("Contig \"$contigs[$i]\" could not be matched: $fscore, $bscore\n");
    }
}
close (LFILE);

print STDERR ("\n");
print STDERR ("Computing Contig Ordering\n");
print STDERR ("-------------------------\n\n");

print LOGFILE ("\n");
print LOGFILE ("Computing Contig Ordering\n");
print LOGFILE ("-------------------------\n\n");

$foundorder = 0;

for ($cutoff = $startingrate; !$foundorder && ($cutoff < 100); $cutoff += $rateinc){
    `$lagandir/utils/scorecontigs /$newdir/filenames $ARGV[0] $newdir/contignames $cutoff > $newdir/ranges`;

    @list = `cat $newdir/ranges`;
    $list[0] =~ /numContigs = (\d+)/;
    next if ($1 == 0);

    `$lagandir/utils/contigorder $newdir/ranges > $newdir/corder`;
    @list = `cat $newdir/corder`;
    chomp $list[0];
    $foundorder = 1 if ($list[0] ne "ordering failed");
}

if ($foundorder){
    open (OFILE, ">$newdir/draft");
    print OFILE ("Draft Ordering\n");
    print OFILE ("--------------\n\n");
    
    @contignames = `cat $newdir/contignames`;
    for ($i = 0; $i < @contignames; $i++){
	$contignames[$i] =~ /(\d+) (\d+) (.*)/;
	$num[$i] = $1; chomp $num[$i];
	$s1shifts[$i] = $2; chomp $s1shifts[$i];
	$filenames[$i] = $3; chomp $filenames[$i];
    }

    @list = `cat $newdir/corder`;
    for ($i = 0; $i < @list; $i++){
	$list[$i] =~ /(\d+) --\> \((\d+) (\d+)\) (.*)/;
	$score = $4; chomp $score;
	print OFILE ("$filenames[$1] --> ($2 $3) score=$score, offset=$s1shifts[$1], index=$num[$1]\n");
    }
    close (OFILE);
    
    print STDERR `cat $newdir/draft`;
    print LOGFILE `cat $newdir/draft`;
    close (LOGFILE);
}
else {
    print STDERR "Could not compute ordering.";
    print LOGFILE "Could not compute ordering.";
    close (LOGFILE);
    exit (0);
}

$filename1 = $ARGV[0];
if (index ($ARGV[0], ".masked") != -1){
    $filename1 = substr $filename1, 0, (rindex $ARGV[0], ".");
    $filename1 = $ARGV[0] if (!(-e $filename1));
}

$filename2 = "$newdir/$contigfile";
if (index ($filename2, ".masked") != -1){
    $filename2 = substr $filename2, 0, (rindex $filename2, ".");
    $filename2 = "$newdir/$contigfile" if (!(-e $filename2));
}

`$lagandir/cmerge.pl $filename1 $filename2 $newdir/draft $filename2.merged -skipfr $pid`;

print STDERR ("\n");
print STDERR ("Computing Final Alignment\n");
print STDERR ("-------------------------\n\n");

`$lagandir/lagan.pl $filename1 $filename2.merged $recurfl $laganparams -bin -out $newdir/alignment.bin`;
`rm anchs.final $newdir/corder $newdir/filenames`;
