#include <stdio.h>
#include <string.h>
#include <math.h>
#include <assert.h>

#define MAX_SEQ 31
#define MAX(a,b) ((a)>(b)?(a):(b))
#define MIN(a,b) ((a)<(b)?(a):(b))

#define CNTS_LEN 6
#define CNTS_A 0
#define CNTS_T 1
#define CNTS_C 2
#define CNTS_G 3
#define CNTS_N 4
#define CNTS_GAP 5

double logs[MAX_SEQ+1];
double maxentr;
char* alpha = "ATCGN-";
int s1shift = 0, s2shift = 0;

typedef struct pair_ints {
  int s;
  int e;
} pair;

typedef struct align_res {
  char* names[MAX_SEQ];
  int algnlen;
  int numseq;
  int* algn;
  char* cnts[CNTS_LEN];
} align;

int cntlets(FILE* input) {
  int numread=0;
  char temp[256];
  char currchar;

  if (feof(input))
    return 0;
  fgets(temp, 255, input);
  if (temp[0] != '>') {
    fprintf(stderr, "File is not in FASTA format!!\n");
    exit(1);
  }
  while ((currchar != '>') && (currchar != EOF)) {
    currchar = fgetc(input);
    if (!isspace(currchar)) {
      currchar = toupper(currchar);
      numread++;
    }
  }
  rewind(input);
  return numread-1;
}

int readseq(FILE* input, align* myal, int seqnum, int checksum) {
  int numread=0, help;
  char temp[256];
  char currchar;

  if (feof(input))
    return 0;
  fgets(temp, 255, input);
  if (temp[0] != '>') {
    fprintf(stderr, "File is not in FASTA format!!\n");
    exit(1);
  }
  myal->names[seqnum] = (char*) malloc((strlen(temp))*sizeof(char));
  strcpy(myal->names[seqnum], temp+1);
  *(strchr(myal->names[seqnum], '\n')) = 0;

  currchar = fgetc(input);
  while (numread <= checksum &&(currchar != '>') && (currchar != EOF)) {
    if (!isspace(currchar)) {
      currchar = toupper(currchar);
      if (!strchr(alpha, currchar)) {
	fprintf(stderr, "WARNING %c converted to N\n", currchar, alpha);
	currchar = 'N';
      }
      help = strchr(alpha, currchar)-alpha;
      myal->cnts[help][numread]++;
      if (help != CNTS_GAP) {
	myal->algn[numread] |= (1 << seqnum);
      }
      numread++;
    }
    currchar = fgetc(input);
  }
  if (currchar == '>')
    ungetc(currchar, input);
  if (numread != checksum) {
    fprintf(stderr, "Sequence (%s) of different lengths (%d v. %d)!!\n", 
	    myal->names[seqnum], numread, checksum);
    exit(1);
  }
  return 1;
}


align* readMultial(FILE* alfile) {
  int letcnt = cntlets(alfile), i, j;
  align* res = (align*)malloc (sizeof(align));
  res->algn = (int*) malloc (sizeof(int)* letcnt);
  for (j=0; j<CNTS_LEN; j++)
    res->cnts[j] = (char*) malloc (sizeof(char)* letcnt);
  for (i=0; i<letcnt; i++) {
    res->algn[i] = 0;
    for (j=0; j<CNTS_LEN; j++)
      res->cnts[j][i] = 0;
  }
  i = 0;
  while (readseq(alfile, res, i++, letcnt)) 
    ;

  res->numseq = i-1;
  res->algnlen = letcnt;
  return res;
}

inline int getScore (align* a, int i){
  return
    ((a->cnts[0][i] * (a->cnts[0][i] - 1)) +
     (a->cnts[1][i] * (a->cnts[1][i] - 1)) +
     (a->cnts[2][i] * (a->cnts[2][i] - 1)) +
     (a->cnts[3][i] * (a->cnts[3][i] - 1))) / 2;
}

int main(int argc, char** argv) {
  FILE *alignfile;
  align* myal;
  int i, j = 0;

  if (argc != 2) {
    fprintf(stderr, "usage:\ncountmatch multi_fasta_file\n");
    exit(1);    
  }
  if (!(alignfile = fopen(argv[1],"r"))) {
    fprintf(stderr, "couldnt open alignment file %s\n",argv[1]);
    return 2;
  }

  myal = readMultial(alignfile);

  for (i = 0; i < myal->algnlen; i++) j += getScore (myal, i);
  printf ("%d\n", j);
}
