#ifndef __MULTIAL_H
#define __MULTIAL_H


#include <stdio.h>

#define MAX_SEQ 31
#define CNTS_LEN 8
#define CNTS_A 0
#define CNTS_T 1
#define CNTS_C 2
#define CNTS_G 3
#define CNTS_CB 4
#define CNTS_GS 5
#define CNTS_GC 6
#define CNTS_GE 7


typedef struct HitLocationList {
  int seq1start;
  int seq2start;
  int seq1end;
  int seq2end;
  float score;
  struct HitLocationList *next;
  struct HitLocationList *bkptr;
  float scoreSoFar;
  char dirty;
} hll;

typedef struct hllpointer {
  int number;
  char isstart;
  hll* myhll;
} hptr;

typedef struct Sequence {
  char* lets;
  int numlets, numsiglets;
  char* name;
  char* rptr;
  char* filename;
} seq;

typedef struct align_res {
  int index;
  int score;
  int algnlen;
  int numseq;
  seq* seqs[MAX_SEQ];
  int* algn;
  char* cnts[CNTS_LEN];
  hll* hlls[MAX_SEQ];
  char dirty;
  struct align_res* nextalign;
} align;


seq* mkConsensus(align* ali);
align* mkSimAlign(seq* seq1);
align* makeAlign(align* ali1, align* ali2, hll* anchors, align **uni);
align* removeSeq(align* ali, int seqnum);
void swapHLL(hll* arg);
hll* remapHLLs(hll* anchs, int which, align* aln, int seqnum);
hll* mergeHLLs(hll* anchs1, int wh1, hll* anchs2, int wh2);
hll* getAnchsFromAlign(align* current, int seqnum, int cutoff);
int getSeqNum(align* ali, seq* trgt);
int printTextAlign(FILE *, align* myalign);
int printFASTAAlign(FILE *, align* myalign);
void printSeqsNames(align *a);

void freeHLL(hll *myHLL);
void freeSequence(seq *mySequence);
void freeAlign(align *myAlign);

void setScores(int matchV, int mismatchV,
	       int gapstartV, int gapendV,
	       int gapcontV, int gapperseqV,
	       int overlapV, int glwidthV);

static char* alpha = "ATCG.N";

static int s1start = 0;
static int s1end = 0;
static int s2start = 0;
static int s2end = 0;
static int match = 18;
static int mismatch = -8;
static int gapstart = -50;
static int gapend = -50;
static int gapcont = -5;
static int gapperseq = -1;
static int overlap = 0;
static int glwidth= 15;
static char dobin = 0;

static float factor, offset;
static int logs[MAX_SEQ*MAX_SEQ];

static FILE* outfile;

#endif


















