import pygame
import os

from grid import Grid

class Application:
	def __init__(self, cover_image, size=(800, 600)):
		self.size = size

		self.font = pygame.font.Font('helvetica.ttf', 36)
		self.font_item = pygame.font.Font('helvetica.ttf', 20)
		self.font_grid = pygame.font.Font('helvetica.ttf', 18)
		self.font_slider = pygame.font.Font('helvetica.ttf', 24)

		self.cover_image = pygame.image.load(os.path.join('img', cover_image))
		self.cover_image_pos = 0, 0
	# __init__

	def draw_loading(self, surface):
		label = self.font.render('Loading...', 1, (255, 255, 255))
		surface.blit(label, self.loading_position())

		pygame.display.flip()
	# draw_loading

	def loading_position(self):
		return (self.size[0]-200, self.size[1]-100)
	# loading_position

	def draw_cover_image(self, surface):
		surface.blit(self.cover_image, self.cover_image_pos)
	# draw_cover_image

	def gen_cover_image_pos(self):
		self.cover_image_pos = self.grid.rect.x/2 - self.cover_image.get_width()/2, Grid.border+20
	# gen_cover_image_pos
# Application