#define ON    0               
#define SOCKET 0              
#define SHORT 1
#define PAWC_SIZE  10000000
#define NDEC_BINS  750       /* Number of declination bins 750*.2 = 150 deg =-60 to 90  */
#define NRA_BINS   1800      /* number of RA bins                                       */
#define NHA_BINS   1800      /* number of HA bins                                       */
#define BINSIZE    0.2       /* binsize of fine bins                                    */
#define TIMETICK   23.9344696*2.   /* time for earth to rotate 0.2 deg    */
#define MIN_BACK   1.e-7           /* minimum background for lookup table */
#define MAX_BACK   500.            /* maximum background for lookup table */
#define T_STEP     0.1             /* Fractional time step             */
#define PROB_BINS  1000            /* segmentation of prob. look up table */
#define PROB_BINSF ((float) PROB_BINS) 
#define MAX_SIG     500            /* maximum signal for lookup table   */
#define NFIT_CUT    5              /* NFIT cut value                    */
#define GBY_CUT     0              /* GBY cut value                     */
#define FRACFIT_CUT 0              /* Freaction of events in fit cut    */
#define X2_CUT      0.0            /* x2 gamma/hadron cut               */

#ifdef ULTRASHORT
#define NDUR           13             /* number of durations searched  27 is right */
#define SHORTER        1              /* variable for naming of histogram files*/
#define MIN_DURATION   0.00025118864  /* minimum search duration          */
#define MAX_DURATION   0.063095734448 /* maximum search duration           */
#define ANALYSIS_FACTOR    31548   /* Factor times minimum analysis time used in ANALYSIS_BITE */
                                   /* =1 for minumum response time (~4s) Longer times make     */
                                   /* the code run faster. 31548 was choosen so ultra short    */
                                   /* and short have the same duration.                        */
#endif

#ifdef SHORT
#define NDUR           14             /* number of durations searched  27 is right */
#define SHORTER        0              /* variable for naming of histogram files*/
#define MIN_DURATION   0.100000       /* minimum search duration          */
#define MAX_DURATION   39.8107171     /* maximum search duration           */
#define ANALYSIS_FACTOR     50     /* Factor times minimum analysis time used in ANALYSIS_BITE */
                                   /* =1 for minumum response time (~4s) Longer times make     */
                                   /* the code run faster                                      */
#endif

#define SEARCHBIN   7              /* binsize = (2*SEARCHBIN+1)*BINSIZE  default =5*/
#define EVBUFFSIZE   2500000        /* event buffer size                 */
#define ZENITH_ANGLE_CUT    45.    /* zenith angle cut for binned search */
#define MAX_DEC             80.    /* maximum declination for binned search */
#define MIN_BACK_TIME       600.   /* minimum background time = 600s     */
#define ANALYSIS_BITE   MAX_DURATION*T_STEP*ANALYSIS_FACTOR  
                                   /* time between grb searches ~4s x FACTOR*/
#define PUBLISH_THRESHOLD   1.e-12  /* thresshold to call publish()       */

#define DEBUG  1                    /* Debugging on/off 1/0             */


typedef struct {
  double st;
  float  nevents;
} TIME_DIST;

typedef struct { 
  unsigned short int ira,idec,iha,filler;
  double time;
} EVENT;
 
typedef struct {
  int iha,idec;
} HIT;

typedef struct {
  unsigned short int sigmap[NRA_BINS][NDEC_BINS];
  int                hittable[NHA_BINS][NDEC_BINS];
  float              backmap[NHA_BINS][NDEC_BINS];
  unsigned int       backmap_ha_dec[NHA_BINS][NDEC_BINS];
  unsigned int       backmap_index[NHA_BINS][NDEC_BINS];
} MAP;

typedef struct {
  unsigned int      count[NDUR][MAX_SIG][PROB_BINS];
  float             value[MAX_SIG][PROB_BINS];
  float             minback,span;
  int               habins[NDEC_BINS];
  int               decmin[NHA_BINS];
  int               decmax[NHA_BINS];
  int               hamin,hamax;
  float             publish_threshold[NDUR];
} PROB;

typedef struct {
  double       t0,duration,back,grbprob;
  int          iha,idec,signal,nallsky_10s,iback,nTail,nBuff,idur;
  int          runum,subrunum;
  unsigned int julDate;
} GRB_CANDIDATE;
  

double index2ha( int );
double index2dec( int );
int ha2index( double );
int dec2index( double );
double pois( double, double);
double intpois( double, double);
int grb_finder(int , EVENT_DATA *, char *);
int grb_finder_init(MAP *, double *, PROB *);
int grb_finder_evaldata_bins (EVENT *,MAP *,PROB *,double,int,int,int,int,unsigned int,int,int);
int grb_finder_evaldata_table(EVENT *,MAP *,PROB *,double,int,int,int,int,unsigned int,int,int);
int grb_finder_backmap( int nBuffBack, PROB *prob, MAP *maps );
void j2c(float,int *,int *,int *,int *);
int grb_finder_publish( int *, GRB_CANDIDATE *, EVENT *, PROB *);
void grb_finder_fileopen(char *,char *,int,unsigned int);
void grb_finder_logger(char *);
int checkEvent(EVENT_DATA *);



