#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
extern int errno;


/* Pass this function the name of a file.  It will attempt to open the
   file for reading and lock it.  If it is successful at opening the
   file and locking it, it will return a FILE pointer to the open file
   stream.  If either the open or the lock fails, it returns a NULL
   pointer. */
FILE *rdlockit(char *s)
{
  static FILE *fp=NULL;
  int fd;
  static char s2[1000];
  static char command[1000];
  struct flock locker;
  char   str[300];
  sprintf(str,"rdlockit called with s=%s, %d\n",s,strcmp(s,"DONE"));
  grb_finder_logger(str);
  if (strcmp(s,"DONE")==0) { /* a file is already open */
    sprintf(str,"closing and deleting file: %s",s2);
    grb_finder_logger(str);
    remove(s2);
    fp=NULL;
    return NULL;
  }

  /* set the file lock structure to lock files, but don't wait for 
     them to be unlocked */
  locker.l_type=F_WRLCK;
  locker.l_len=locker.l_start=locker.l_whence=0;

  //  fprintf(stderr," Trying to open  %s\n",s);
  if ((fd=open(s,O_RDWR))>=0) {     /* If we can open it for reading */
    //    fprintf(stderr,"  Opened %s\n",s);
 /*   if (fcntl(fd,F_SETLK , &locker)>=0) { */ /* If we can lock file */
    if (1) {  /* If we can lock file */
      fp=fdopen(fd,"r");              /* Give it a file pointer */
      sprintf(s2,"%s-",s);
      sprintf(command,"mv %s %s",s,s2);
      sprintf(str,"executing: %s\n",command);
      grb_finder_logger(str);
      system(command);
    } else {
      //perror("fcntl");
      close(fd);
    }
  } else {
    perror("open:");
  }

  return(fp);
}

/* When passed the name of a file, this function will attempt to open
   that file for writing and lock it.  If a lock can not be obtained
   the function just waits until a lock can be obtained!  */

FILE *wrlockit( char *s)
{

  FILE *fp=NULL;
  int fd; 
  struct flock locker;

  fp=fopen(s,"w");
  fd=fileno(fp);     /* Get the file descriptor */
  /* Wait until we can obtain a write lock on that puppy */
  locker.l_type=F_WRLCK;
  locker.l_len=locker.l_start=locker.l_whence=0;
  if (fcntl(fd,F_SETLKW, &locker) <0) {
    perror("fcntl lock");    /* The bad news. Something bad happened */
    fprintf(stderr,"Error obtaining lock on %s\n",s);
    exit(5);
  }

  return(fp);

}

