#include "Reconstruction.h"
#include "Offline.h"
#include "cfortran.h"
#include "hbook.h"
#include "grb.h"

double pois( double, double);
double intpois( double, double);


int grb_finder_evaldata_bins(EVENT *evbuffer,MAP *maps,PROB *prob,
                             double duration, int dindex, int nTail, 
                             int nTailBack,int nBuff, unsigned int julDate,
			     int runum, int subrunum) 
{
  double t0,t1,tstart,tend,t0_10s,t1_10s;
  int nallsky_10s;
  int dha,xha,ddec,xdec,nallsky,nEval,icount,maxcount,iback,nhits;
  int iha,idec,i,j,signal,iend;
  float temp,xallsky,total;
  int   ixallsky,nhabins,ipublish;
  unsigned short int *sigptr;
  unsigned int       *backptr;
  static int iev0[NDUR],iev1[NDUR],iev0_10s[NDUR],iev1_10s[NDUR];
  char   str[300];
  GRB_CANDIDATE cand;
  int crap=0;


  /* tstart and tend are the start and end times for the interval to search */
  /* t0 and t1 are the starting and ending times for the search interval   */
  /* t1 and t0 are taken with respect to the start of the day, not the first event */

  tstart      = evbuffer[nTail].time-duration;
  if (tstart<evbuffer[nTailBack].time) tstart=evbuffer[nTailBack].time;
  iend        = nTail+nBuff-1;
  if (iend>EVBUFFSIZE) iend-=EVBUFFSIZE;
  tend        = evbuffer[iend].time;
  t0          = (floor(1.+tstart/(duration*T_STEP)))*duration*T_STEP;

  if (nTail==nTailBack) {  // background was reset, don't look back in time 
    iev1[dindex]     = nTailBack;
    iev0[dindex]     = nTailBack;
    iev1_10s[dindex] = nTailBack;
    iev0_10s[dindex] = nTailBack;
  } else {             /* otherwise, start up where I left off          */
    iev1[dindex]     = iev0[dindex];
    iev1_10s[dindex] = iev0_10s[dindex];
  }
  nallsky     = 0;
  nallsky_10s = 0;
  nEval       = 0;
  t0_10s      = tstart;
  nhits       = 0;
  ipublish    = 1;   // publish not called 
  
  sprintf(str," %f %f ",tstart,tend);
  grb_finder_logger(str);
  
  // zero out signal map
  sigptr = &(maps->sigmap[0][0]);//why not use a memset?
  for (i=0;i<NHA_BINS*NDEC_BINS;i++) {
    *sigptr = 0;
    sigptr++;
  }
   

  if (t0+duration>tend) goto NOTHING_TO_DO;
  // step through time bins 
  do {
    // add events to signal map
    t1 = t0+duration;
    while (evbuffer[iev1[dindex]].time<t1) {
      iha = evbuffer[iev1[dindex]].iha;
      idec= evbuffer[iev1[dindex]].idec;
      nhabins = prob->habins[idec];
      if (iha>=prob->hamin-nhabins && iha<=prob->hamax+nhabins && 
          idec>=prob->decmin[iha]-SEARCHBIN && 
          idec<=prob->decmax[iha]+SEARCHBIN) {
        for (dha=-nhabins;dha<=nhabins;dha++) {
          for (ddec=-SEARCHBIN;ddec<=SEARCHBIN;ddec++) {
            maps->sigmap[iha+dha][idec+ddec]++;
          }
        }
      }
      iev1[dindex]++;
      if(iev1[dindex]==EVBUFFSIZE) iev1[dindex]=0;
      nallsky++;
    }
    // remove events from signal map 
    while (evbuffer[iev0[dindex]].time<t0) {
      iha = evbuffer[iev0[dindex]].iha;
      idec= evbuffer[iev0[dindex]].idec;
      nhabins = prob->habins[idec];
      if (iha>=prob->hamin-nhabins && iha<=prob->hamax+nhabins &&
          idec>=prob->decmin[iha]-SEARCHBIN && 
          idec<=prob->decmax[iha]+SEARCHBIN) {
        for (dha=-nhabins;dha<=nhabins;dha++) {
          for (ddec=-SEARCHBIN;ddec<=SEARCHBIN;ddec++) {
            maps->sigmap[iha+dha][idec+ddec]--;
          }
        }
      }
      iev0[dindex]++;
      if (iev0[dindex]==EVBUFFSIZE) iev0[dindex]=0;
      nallsky--;
    }
  
    // count events in 10s time window arround datapoint if timescale <10s 
    if (duration<10.) {
      t0_10s = t0+duration/2.-5.;
      t1_10s = t0_10s+10.;
      if (t0_10s<tstart) {t0_10s=tstart;   t1_10s=tstart+10.;}
      if (t1_10s>tend)   {t0_10s=tend-10.; t1_10s=tend; }
      while (evbuffer[iev1_10s[dindex]].time<t1_10s) { 
        iev1_10s[dindex]++; 
        if (iev1_10s[dindex]==EVBUFFSIZE) iev1_10s[dindex]=0;
        nallsky_10s++; 
      }
      while (evbuffer[iev0_10s[dindex]].time<t0_10s) { 
        iev0_10s[dindex]++; 
        if (iev0_10s[dindex]==EVBUFFSIZE) iev0_10s[dindex]=0;
        nallsky_10s--; 
      }
    } else {
      nallsky_10s = (int) (((float)nallsky)*10./duration);
    }
    if (nallsky_10s==0 && nallsky!=0) {
      sprintf(str,"ERROR: Background=0: %d %d %f %f %f %f\n",iev1_10s[dindex],
              iev0_10s[dindex], t1_10s,t0_10s,tstart,tend);
      grb_finder_logger(str);
    }

    nEval++;
    /* if (nEval%10000==0) {sprintf(str,"Evaluating %d, %f\n",nEval/10,t0);
       grb_finder_logger(str);}*/
    /* Now I have the signal and background map, evaluate map */
    xallsky = log((((float) nallsky_10s)*duration/10.))*PROB_BINSF/prob->span;
    ixallsky = (int) (xallsky+.5);
    for (iha=prob->hamin+1;iha<prob->hamax;iha+=3) {
      icount = prob->decmin[iha]-2;
      maxcount = prob->decmax[iha];
      sigptr =&(maps->sigmap[iha][icount]);
      backptr=&(maps->backmap_index[iha][icount]);
      do {
        icount+=3;
        sigptr+=3;
        backptr+=3;
        signal= *sigptr;
        if (signal>0) {
          iback  = (*backptr)+ixallsky;
          if (iback>=0 && iback<PROB_BINS && signal>=0 && signal<MAX_SIG) {
            prob->count[dindex][signal][iback]++;
          } else { 
            sprintf(str,"Overflow: %d %d %d %d %f %f %f %f\n",signal,iback,nallsky_10s,
                    ixallsky,xallsky,duration,PROB_BINSF,prob->span);
	    grb_finder_logger(str);
          }
          /* search more finely for low prob */
          if (prob->value[signal][iback]<1.e-4) { 
            for (i=-1;i<=1;i++) {
              for (j=-1;j<=1;j++) {
                signal = maps->sigmap[iha+i][icount+j];
                iback  = maps->backmap_index[iha+i][icount+j]+ixallsky;
                if (prob->value[signal][iback]<prob->publish_threshold[dindex]) {
                  cand.iha         = iha+i;
                  cand.idec        = icount+j;
                  cand.t0          = t0;
                  cand.duration    = duration;
                  cand.runum       = runum;
		  cand.subrunum    = subrunum;
		  cand.signal      = signal;
                  cand.back        = exp(((float)iback)*prob->span/PROB_BINSF+prob->minback);
                  cand.grbprob     = prob->value[signal][iback];
                  cand.nallsky_10s = nallsky_10s;
                  cand.iback       = iback;
                  cand.julDate     = julDate;
                  cand.nTail       = nTail;
                  cand.nBuff       = nBuff;
                  cand.idur        = dindex;
		  grb_finder_publish(&ipublish, &cand, evbuffer, prob);
                }
                if (i!=0 || j!=0)  /* don't look twice at (0,0) */
                  prob->count[dindex][signal][iback]++;
              }
            }
          }
        }
      } while (icount<maxcount);
    }

    t0+=T_STEP*duration;
  } while (tend-t0>duration);

  if (ipublish==0) {
    ipublish = 2;
    grb_finder_publish(&ipublish, &cand, evbuffer, prob);
  }
 NOTHING_TO_DO: 
}
