#include "Reconstruction.h"
#include "Offline.h"
#include "cfortran.h"
#include "hbook.h"
#include "grb.h"

#define SEARCH_THRESH 2

double pois( double, double);
double intpois( double, double);


int evaldata_table(EVENT *evbuffer,MAP *maps,PROB *prob,double duration,
                   int dindex, int nBuff, unsigned int julDate) 
{
  double t0,t1,tstart,tend,t0_10s,t1_10s;
  int iev1_10s,iev0_10s,nallsky_10s,ihits;
  int dha,xha,ddec,xdec,iev0,iev1,nallsky,nEval,icount,iback,nhits;
  int iha,idec,i,j,signal;
  float temp,xallsky,total;
  int   ixallsky,nhabins,maxdec,ipublish;
  unsigned short int *sigptr;
  unsigned int       *backptr;
  static HIT hitlist[1000000];
  

  tstart      = evbuffer[0].time;
  tend        = evbuffer[nBuff-1].time;
  t0          = tstart;
  iev1        = 0;
  iev0        = 0;
  iev1_10s    = 0;
  iev0_10s    = 0;
  nallsky     = 0;
  nallsky_10s = 0;
  nEval       = 0;
  t0_10s      = tstart;
  nhits       = 0;
  ipublish    = 1;   /* publish not yet called */

  /* zero out signal map */
  sigptr = &(maps->sigmap[0][0]);
  for (i=0;i<NHA_BINS*NDEC_BINS;i++) {
    *sigptr = 0;
    sigptr++;
  }
  
  do {
    /* add events to signal map */
    t1 = t0+duration;
    while (evbuffer[iev1].time<t1) {
      iha = evbuffer[iev1].iha;
      idec= evbuffer[iev1].idec;
      nhabins = prob->habins[idec];
      if (iha+nhabins>=prob->hamin && iha-nhabins<=prob->hamax &&
          idec+SEARCHBIN>=prob->decmin[iha] && idec-SEARCHBIN<=prob->decmax[iha]) {
        for (dha=-nhabins;dha<=nhabins;dha++) {
          for (ddec=-SEARCHBIN;ddec<=SEARCHBIN;ddec++) {
            maps->sigmap[iha+dha][idec+ddec]++;
            /* add to hit list */
            if (maps->sigmap[iha+dha][idec+ddec]==SEARCH_THRESH) {
              hitlist[nhits].iha  = iha+dha;
              hitlist[nhits].idec = idec+ddec;
              maps->hittable[iha+dha][idec+ddec]=nhits;
              nhits++;
            }
          }
        }
      }
      iev1++;
      nallsky++;
    }
    /* remove events from signal map */
    while (evbuffer[iev0].time<t0) {
      iha = evbuffer[iev0].iha;
      idec= evbuffer[iev0].idec;
      nhabins = prob->habins[idec];
      if (iha+nhabins>=prob->hamin && iha-nhabins<=prob->hamax &&
          idec+SEARCHBIN>=prob->decmin[iha] && idec-SEARCHBIN<=prob->decmax[iha]) {
        for (dha=-nhabins;dha<=nhabins;dha++) {
          for (ddec=-SEARCHBIN;ddec<=SEARCHBIN;ddec++) {
            /* delete from hit list */
            /* when removing the data, I move the last table element to */
            /* the new opening. This could go faster if I used pointers */
            if (maps->sigmap[iha+dha][idec+ddec]==SEARCH_THRESH) {
              ihits = maps->hittable[iha+dha][idec+ddec];
              hitlist[ihits].iha  = hitlist[nhits-1].iha;
              hitlist[ihits].idec = hitlist[nhits-1].idec;
              maps->hittable[hitlist[ihits].iha][hitlist[ihits].idec]=ihits;
              nhits--;
            }
            maps->sigmap[iha+dha][idec+ddec]--;
          }
        }
      }
      iev0++;
      nallsky--;
    }

    /* count events in 10s time window arround datapoint */
    t0_10s = t0+duration/2.-5.;
    t1_10s = t0_10s+10.;
    if (t0_10s<tstart) {t0_10s=tstart;   t1_10s=tstart+10.;}
    if (t1_10s>tend)   {t0_10s=tend-10.; t1_10s=tend; }
    while (evbuffer[iev1_10s].time<t1_10s) { iev1_10s++; nallsky_10s++; }
    while (evbuffer[iev0_10s].time<t0_10s) { iev0_10s++; nallsky_10s--; }

    nEval++;
    /* Now I have the signal and background map */
    /* and the list of hits, search the map */
    xallsky = log((((float) nallsky_10s)*duration/10.))*PROB_BINSF/prob->span;
    ixallsky = (int) (xallsky+.5);
    for (i=0;i<nhits;i++) { 
      iha  = hitlist[i].iha;
      idec = hitlist[i].idec;
      signal = maps->sigmap[iha][idec];
      iback  = maps->backmap_index[iha][idec]+ixallsky;
      if (iback>=0 && iback<PROB_BINS && signal>=0 && signal<MAX_SIG) {
        prob->count[dindex][signal][iback]++;
      } else {
        printf ("Overflow: %d %d %d %d\n",signal,iback,maps->backmap_index[iha][idec],ixallsky);
      }
      if (prob->value[signal][iback]<1.e-12) 
        publish(&ipublish,iha,idec,t0,duration,signal,
                exp(((float)iback)*prob->span/PROB_BINSF+prob->minback),
                prob->value[signal][iback],iback,ixallsky,julDate);
    }

    t0+=T_STEP*duration;
  } while (tend-t0>duration);

}
