#include "Reconstruction.h"
#include "Offline.h"
#include "cfortran.h"
#include "hbook.h"
#include "grb.h"

double pois( double, double);
double intpois( double, double);


int evaldata_bins(EVENT *evbuffer,MAP *maps,PROB *prob,double duration,
                  int dindex, int nBuff, unsigned int julDate) 
{
  double t0,t1,tstart,tend,t0_10s,t1_10s;
  int iev1_10s,iev0_10s,nallsky_10s;
  int dha,xha,ddec,xdec,iev0,iev1,nallsky,nEval,icount,maxcount,iback,nhits;
  int iha,idec,i,j,signal;
  float temp,xallsky,total;
  int   ixallsky,nhabins,ipublish;
  unsigned short int *sigptr;
  unsigned int       *backptr;

  tstart      = evbuffer[0].time;
  tend        = evbuffer[nBuff-1].time;
  t0          = tstart;
  iev1        = 0;
  iev0        = 0;
  iev1_10s    = 0;
  iev0_10s    = 0;
  nallsky     = 0;
  nallsky_10s = 0;
  nEval       = 0;
  t0_10s      = tstart;
  nhits       = 0;
  ipublish    = 1;   /* publish not called */

  /* zero out signal map */
  sigptr = &(maps->sigmap[0][0]);
  for (i=0;i<NHA_BINS*NDEC_BINS;i++) {
    *sigptr = 0;
    sigptr++;
  }

  /* step through time bins */
  do {
    /* add events to signal map */
    t1 = t0+duration;
    while (evbuffer[iev1].time<t1) {
      iha = evbuffer[iev1].iha;
      idec= evbuffer[iev1].idec;
      nhabins = prob->habins[idec];
      if (iha>=prob->hamin-nhabins && iha<=prob->hamax+nhabins && 
          idec>=prob->decmin[iha]-SEARCHBIN && 
          idec<=prob->decmax[iha]+SEARCHBIN) {
        for (dha=-nhabins;dha<=nhabins;dha++) {
          for (ddec=-SEARCHBIN;ddec<=SEARCHBIN;ddec++) {
            maps->sigmap[iha+dha][idec+ddec]++;
          }
        }
      }
      iev1++;
      nallsky++;
    }
    /* remove events from signal map */
    while (evbuffer[iev0].time<t0) {
      iha = evbuffer[iev0].iha;
      idec= evbuffer[iev0].idec;
      nhabins = prob->habins[idec];
      if (iha>=prob->hamin-nhabins && iha<=prob->hamax+nhabins &&
          idec>=prob->decmin[iha]-SEARCHBIN && 
          idec<=prob->decmax[iha]+SEARCHBIN) {
        for (dha=-nhabins;dha<=nhabins;dha++) {
          for (ddec=-SEARCHBIN;ddec<=SEARCHBIN;ddec++) {
            maps->sigmap[iha+dha][idec+ddec]--;
          }
        }
      }
      iev0++;
      nallsky--;
    }

    /* count events in 10s time window arround datapoint if timescale <10s */
    if (duration<10.) {
      t0_10s = t0+duration/2.-5.;
      t1_10s = t0_10s+10.;
      if (t0_10s<tstart) {t0_10s=tstart;   t1_10s=tstart+10.;}
      if (t1_10s>tend)   {t0_10s=tend-10.; t1_10s=tend; }
      while (evbuffer[iev1_10s].time<t1_10s) { iev1_10s++; nallsky_10s++; }
      while (evbuffer[iev0_10s].time<t0_10s) { iev0_10s++; nallsky_10s--; }
    } else {
      nallsky_10s = (int) (((float)nallsky)*10./duration);
    }

    nEval++;
    /* if (nEval%10000==0) printf("Evaluating %d, %f\n",nEval/10,t0); */
    /* Now I have the signal and background map, evaluate map */
    xallsky = log((((float) nallsky_10s)*duration/10.))*PROB_BINSF/prob->span;
    ixallsky = (int) (xallsky+.5);
    for (iha=prob->hamin+1;iha<prob->hamax;iha+=3) {
      icount = prob->decmin[iha]-2;
      maxcount = prob->decmax[iha];
      sigptr =&(maps->sigmap[iha][icount]);
      backptr=&(maps->backmap_index[iha][icount]);
      do {
        icount+=3;
        sigptr+=3;
        backptr+=3;
        signal= *sigptr;
        if (signal>0) {
          iback  = (*backptr)+ixallsky;
          if (iback>=0 && iback<PROB_BINS && signal>=0 && signal<MAX_SIG) {
            prob->count[dindex][signal][iback]++;
          } else { 
            printf ("Overflow: %d %d %d %d\n",signal,iback);
          }
          /* search more finely for low prob */
          if (prob->value[signal][iback]<1.e-4) { 
            for (i=-1;i<=1;i++) {
              for (j=-1;j<=1;j++) {
                signal = maps->sigmap[iha+i][icount+j];
                iback  = maps->backmap_index[iha+i][icount+j]+ixallsky;
                if (prob->value[signal][iback]<1.e-12)
                  publish(&ipublish,iha+i,icount+j,t0,duration,signal,
                    exp(((float)iback)*prob->span/PROB_BINSF+prob->minback),
                    prob->value[signal][iback],nallsky_10s,iback,julDate);
                if (i!=0 || j!=0)  /* don't look twice at (0,0) */
                  prob->count[dindex][signal][iback]++;
              }
            }
          }
        }
      } while (icount<maxcount);
    }

    t0+=T_STEP*duration;
  } while (tend-t0>duration);
}
