/*
 * FILE: MilagroEvent4.c
 *
 */

#include<sys/stat.h>
#include <unistd.h>
#include<sys/types.h>
#include<dirent.h>
#include<string.h>
#include<stdio.h> 
#include<limits.h>
#include "Reconstruction.h"
#include "Offline.h"

#define MAX_RESCAN 1000

#define STANDARD_MODE     0
#define PROCESSING_MODE   1

FILE *rdlockit(char *);

FILE *nextfileplease(char *fl, int reset, int event_mode)
{
  static FILE *fplistin=NULL,*fp=NULL;
  static char s[256],fn[256],prefix[256]="\0";
  int ln,erk,fgetreturn;
  char str[300];
  if (fplistin==NULL || reset) {    /* Called the first time, or if reset requested */
    /* if the stream is open then close it. */
    if (fplistin!=NULL) { pclose(fplistin); fplistin=NULL; } 
    /* Make a command to list the files */
    sprintf(str,"Reading file list\n");
    grb_finder_logger(str);
    snprintf(s,256,"for i in %s ;do  [ -r $i ] && [ -f $i ] && echo $i ; done",fl);    

    if ((fplistin=popen(s,"r"))==NULL) {   /* get list of files */
      sprintf(str,
	      "nextfileplease: cannot do a directory listing on your files\n");
      grb_finder_logger(str);
      return NULL;
    }
  }

  do {
    fgetreturn = (int) fgets(fn,256,fplistin);  /* Get the name of the next file */
    if (fgetreturn==0) {   
      pclose(fplistin);       /* We've reached the end of the list, close the stream */
      fplistin=NULL;
      return NULL;  
    }
    fn[ln=(strlen(fn)-1)]='\0';    /* Get rid of the new line character.*/
    sprintf(str,"Attempting to open %s\n",fn);
    grb_finder_logger(str);
    /* open the file */
    /* PROCESSING MODE: mv file to filename- and lock file after opening */
    /* STANDARD MODE:   just open file                                   */
    if (event_mode==PROCESSING_MODE) fp=rdlockit(fn);
    if (event_mode==STANDARD_MODE)   fp=fopen(fn,"r");    
    if (fp==NULL){
      sprintf(str,"nextfileplease: Could not open file %s\n",fn);
      grb_finder_logger(str);
    }
  } while (fp==NULL);         /* open new files until we get one that opens*/
  
  return(fp);

}

/* ================ MilagroEvent4 ==================== */
int MilagroEvent4(EVENT_DATA *eventData, DATA_CONTROL *controlInfo, GRID_COORD *coords, CAL_CONTROL *calCon)
{
  static FILE *fp=NULL;
  int  i,status=0;
  static int event_mode;
  char  str[300];
  event_mode=PROCESSING_MODE;

  /* called for the first time or no open files */
  /* PROCESSING_MODE: keep trying until a file opens or max attempts reached */
  /* STANDARD_MODE:   Scan file list and open. Don't retry on failure        */
  i=0;
  if(fp==NULL) {    /* Open a file */
    do {
      if (i!=0) {
	sprintf(str,"Waiting for next file\n"); 
	grb_finder_logger(str);
	system("touch /home/daq/burst/short");
	sleep(30); 
      }
      fp=nextfileplease(controlInfo->inFile,0,event_mode);
      i++;
    } while (fp==NULL && i<MAX_RESCAN && event_mode==PROCESSING_MODE);
    if (fp==NULL)  return 0;    /* I can't open a file. Return status is 0 */
  }
  
  do {
    /* Check if we reached the end of our files */
    if (fp!=NULL) status=DataRead(controlInfo,eventData,fp,coords);
    if (status==0) {                      /* DataRead reached end of file                */
      rdlockit("DONE");
      fclose(fp); fp=NULL;                /* close file and set the file pointer to NULL */
      /* try getting another file if we're done with the current one */
      fp=nextfileplease(controlInfo->inFile,0,event_mode); 
      if (fp==NULL && event_mode==PROCESSING_MODE) {
        i=0;
        do {
          if (i!=0) {
	    sprintf(str,"Waiting for next file\n"); 
	    grb_finder_logger(str);
	    system("touch /home/daq/burst/short");
	    sleep(30);
	  }
          fp=nextfileplease(controlInfo->inFile,1,event_mode);
          i++;
        } while (fp==NULL && i<MAX_RESCAN);
        if (i==MAX_RESCAN) return 0;
      } else { /* mode not PROCESSING_MODE */
        if (fp==NULL) return 0;
      }
    }
  } while (!status);
  
  return status;
}
