/* ********************************************************************** */
/*
  query.c 
  Input: the graph representation of the query.
  Output: the output file.

  Note: query.c creates the files opfile, need etc.. (see algebra5.k);
        runs algebra5 and gets the output file (query_file_name.out).
		  If the query has wildcards, query.c parses the output file to
		  delete from it substructures that don't satisfy
		  the wildcard connection
		  (n2/././n1 ;  n1 and n2 have a  wildcard connection).

 */
/* ********************************************************************** */
#include "common.h"
#include "commonstruct.h"
#include "stringset.h"
#include "query.h"



struct Query_Struct{
  char **qtypeG;         /* the node types of the query */
  int  *qouttable;       /*position of nodes in the output table */
  int lengthtables;      /* the length of the tables that are intersected to compose the query */
  int wildlengthtables;  /* the length of the tables that are intersected to compose the query with wildcards*/
  char **qpath;          /* the paths in the query */
  char **qoperation;     /* the tables name, they are the input of algebra operations*/ 
  char *p;               /* to read a string */
  char **nameop;         /* the name of the tables in the operation */
  char outlentable[1000]; 
  int numpath;
  int flag;	
  FILE *needfile;        /* list of tables to select in the graphs see algebra5.k*/
  FILE *needf1;          /* list of tables and graphs (search space) (different format from above) see algebra5.k*/
  FILE *opfile;          /* list of operations */
  FILE *fopfile1;        /* list of operations */
  char *spit;            /* list of tables to print in the output file*/
  char positions1[1000];  /* store the positions of nodes that are unique in the final table*/
  char positions[1000];   /* store the positions of nodes that are unique in each table*/
  char wildpositions[1000]; /* store the positions of nodes that are connected with wildcards*/
  int num;
  int *connect;            /*the nodes with connect value equals to 0 are in other connected components*/
  int dimconnect;          /*number of nodes in the connected component (subgraph)*/
  int jop;                 /*indexes for the qoutablejop*/
  int totsubgraph;         /* the number of components in the graph; the query graph is not connected */
  int *path;               /* store paths, to visit a graph in the dataset for a query that contains wildcards*/
  listwildconnection *wildhead; /*information about the wildcard connection */
  StringSet ss;			        /* object to read and store the type strings from the input file */
  int sizeoutids;
};




/* ********************************************************************** */
void Inz(Query q,int num)
{
  int i;
  
  q->qoperation=(char **) calloc(sizeof(char *),num*num);
  assert(q->qoperation!=NULL);
  q->qpath=(char **) calloc(sizeof(char *),num*num);
  assert(q->qpath!=NULL);

  printf("%d ",num);fflush(stdout);
  printf("%s",q->qtypeG[0]);
  for(i=0;i<num;i++)
	 strcpy(q->qtypeG[i],"");
  q->numpath=0;
  q->dimconnect=0;

}


/* ********************************************************************** */
/* 
  Store the positions of the nodes in a table that can not be repeated.
  (see algebra5.k; TESTUNIQUE operation).
*/
/* ********************************************************************** */
void GiveStringPosition(int *markDselect,int indop, int numop, int offset,int lentab,int notrepeat[][numop],Query q)
{
  int i, flag=0;
  int posinout;
    
  strcpy(q->positions,"");
  if(markDselect[indop]==1) return;
  for(i=0;i<numop;i++)
    if(markDselect[i]==1 && strcmp(q->nameop[indop],q->nameop[i])==0) 
      {
		  markDselect[indop]=1;
		  free(q->qoperation[i]); 
		  q->qoperation[i]=(char *) calloc(sizeof(char),(strlen(q->nameop[i])+1));
		  assert(q->qoperation[i]!=NULL);
		  sprintf(q->qoperation[i],q->nameop[i]);
		  flag=1;
      }
  for(i=0;i<q->num;i++)
    if(notrepeat[i][indop]!=-1)
      {
	sprintf(q->positions,"%s %d",q->positions,offset+notrepeat[i][indop]);
	if(lentab!=-1)
	  {
	    sprintf(q->positions1,"%s %d",q->positions1,notrepeat[i][indop]+offset+lentab);
	  }
      }
  if(lentab==-1)
    strcpy(q->positions1,q->positions);
  if(flag==1)
    strcpy(q->positions,""); 

}


/* ********************************************************************** */
/*
  build the k operations to check that: nodes placed in given positions
  are not repeated.
 */
/* ********************************************************************** */
void Dselect(int *markDselect,int i, int len, Query q)
{
 
  //if(len==2) return;

  if(strcmp(q->positions,"")!=0)
    {

		if(strlen(q->positions)>2)
		  {
			 markDselect[i]=1;
			 fprintf(q->opfile,"TESTUNIQUE qoutable%d %s %s\n",q->jop,q->qoperation[i],q->positions);
			 free(q->qoperation[i]); 
			 q->qoperation[i]=(char *) calloc(sizeof(char),(strlen("qoutable")+15));
			 assert(q->qoperation[i]!=NULL);
			 sprintf(q->qoperation[i],"qoutable%d",q->jop);
			 q->jop=q->jop+1;
		  }
    }
}

/* ********************************************************************** */
/*
  It is called from FindOutSubGraph.
 */
/* ********************************************************************** */
void CreateOutput(int j,int numop, int offset[],int lenghtableop[], int notrepeat[][numop], Query q)
{
  int flag,len,i,i0=0,i1,k,icp, markDselect[numop];
  char str[500];
  
 
  for(i=0;i<numop;i++)
    markDselect[i]=-1;
  

  while(i0<numop && q->qoperation[i0]==NULL)
    i0++;
  i1=i0;
  i1++;
  while(i1<numop && q->qoperation[i1]==NULL)
    i1++;
    
  if(i1>=numop)
    {
      if(i0<numop)
	{
	  GiveStringPosition(markDselect,i0,numop,offset[i0],-1,notrepeat,q);
	  if(strlen(q->positions)<=2)
	    sprintf(q->spit,"%s %s",q->spit,q->qoperation[i0]);
	  else
	    {
	      Dselect(markDselect,i0,lenghtableop[i0],q);
	      sprintf(q->spit,"%s %s",q->spit,q->qoperation[i0]);
	    }
	  //fprintf(opfile,"UNIQUE qoutable%d\n",j-1);
	  //fprintf(q->opfile,"SPIT %s qoutable%d\n",q->spit,q->jop-1);
	  //sprintf(q->spit,"%s qoutable%d",q->spit,q->jop-1);
	  //sprintf(q->spit,"%s %s",q->spit,q->qoperation[q->jop-1]);
	}
      return;
    }
  
  
  if((strcmp(q->qoperation[i0],q->qoperation[i1])!=0) || (q->qoperation[i0][0]!='q')
     || (q->qoperation[i1][0]!='q') )
    {
      GiveStringPosition(markDselect,i0,numop,offset[i0],-1,notrepeat,q);
      Dselect(markDselect,i0,lenghtableop[i0],q);
      
      GiveStringPosition(markDselect,i1,numop,offset[i1],lenghtableop[i0],notrepeat,q);
      Dselect(markDselect,i1,lenghtableop[i1],q);
      
      fprintf(q->opfile,"CARTESIANPRODUCT qoutable%d %s %s\n",q->jop,q->qoperation[i0],q->qoperation[i1]);
      q->jop++;
      if(strcmp(q->positions1,"")!=0)
		  {
			 fprintf(q->opfile,"TESTUNIQUE qoutable%d  qoutable%d %s\n",q->jop, q->jop-1, q->positions1);
			 q->jop++;
		  }
      len=lenghtableop[i0]+lenghtableop[i1];
      icp=q->jop;
      sprintf(str,"CARTESIANPRODUCT qoutable%d qoutable%d",q->jop,q->jop-1);
      q->jop++;
    }
  else
    {
      GiveStringPosition(markDselect,i1,numop,offset[i1],-1,notrepeat,q);
      Dselect(markDselect,i1,lenghtableop[i1],q);
      len=lenghtableop[i1];
      icp=q->jop;
      sprintf(str,"CARTESIANPRODUCT qoutable%d  %s",q->jop,q->qoperation[i1]);
      q->jop++;
    }
  i1++;
  for(i=i1;i<numop;i++)
    {
      if(q->qoperation[i]!=NULL)
	{
	  if(q->qoperation[i][0]!='q')
	    {
	      GiveStringPosition(markDselect,i,numop,offset[i],len,notrepeat,q);
	      Dselect(markDselect,i,lenghtableop[i],q);   
	      fprintf(q->opfile,"%s %s\n",str,q->qoperation[i]);
	      if(strcmp(q->positions1,"")!=0)
			  {
				 fprintf(q->opfile,"TESTUNIQUE qoutable%d  qoutable%d %s\n",q->jop, icp, q->positions1);
				 q->jop++;
			  }
	      len=len+lenghtableop[i];
	      icp=q->jop;
	      sprintf(str,"CARTESIANPRODUCT qoutable%d qoutable%d",q->jop,q->jop-1);
	      q->jop++;
	    }       
	  else
	    {
	      flag=0;
	      for(k=i-1;k>=0;k--)  
			  if(strcmp(q->qoperation[i],q->qoperation[k])==0)
		  flag=1;
	      if(flag==0)
			  {
				 GiveStringPosition(markDselect,i,numop,offset[i],len,notrepeat,q);
				 Dselect(markDselect,i,lenghtableop[i],q);
				 fprintf(q->opfile,"%s %s\n",str,q->qoperation[i]);
				 if(strcmp(q->positions1,"")!=0)
					{
					  fprintf(q->opfile,"TESTUNIQUE qoutable%d  qoutable%d %s\n",q->jop, icp, q->positions1);
					  q->jop++;
					}
				 len=len+lenghtableop[i];
				 icp=q->jop;
				 sprintf(str,"CARTESIANPRODUCT qoutable%d qoutable%d",q->jop,q->jop-1);
				 q->jop++;
			  }
	    }
	}
    }
  //fprintf(opfile,"UNIQUE qoutable%d\n",j-2);
  //fprintf(q->opfile,"SPIT %s qoutable%d\n",q->spit,q->jop-2);  
  sprintf(q->spit,"%s qoutable%d",q->spit,q->jop-2);  

}




/* ********************************************************************** */
//	 It gives a value of a string before the space 
//	 es: 5 67 7 it returns 5
/* ********************************************************************** */
int GetElementInString(Query q)
{
  int indop=-1;
  char str[10];

  strcpy(str,"");
  while(q->p[0]==' ' && q->p[0]!='\0')
    q->p++;
  while(q->p[0]!=' ' && q->p[0]!='\0')
    {
      sprintf(str,"%s%c",str,q->p[0]);
      q->p++;
    }
  indop=atoi(str);
  return indop; 
}





/* ********************************************************************** */
/*
 Input: the number of paths in the query graph. Each path is a table
 in a dataset graph.
 FindOutputSubGraph combines the paths, builds the k algebra
 operations to find substructures matching with the query.
 */
/* ********************************************************************** */
void FindOutputSubGraph(int numop, int num, Query q)
{

   int  jj,i, pos=0, lenghtpath=0,precpos=0, elm=0, indop=0, start=0,k=0;
   char str[200], str1[500];
   char n[100], *p1;
   int offset[numop], temp[numop], lenghtableop[numop], worktable[numop],prec=0;   
   int notrepeat[num][numop],wasin[num];

	
	char opfwrite[numop*4][500];
	int numoperator[numop*4];
	int kk, operator=0;
	int lt, run;
	
#ifdef DEBUG
	if(DBG_CHK){ DBG_MSG;
   printf("numero di op %d", numop);
	printf("The QOPEARTION ");
	for(i=0;i<numop;i++)
     {
		 printf(" %s ",q->qoperation[i]);
     }
	}
#endif	

	//	printf("%d",num);getchar();
   //if(numop==1) return;
   for(i=0;i<numop;i++)
     {         
       for(jj=0;jj<num;jj++) /*num has to be q->num, the total size*/
			{
			  notrepeat[jj][i]=-1;

			}
       worktable[i]=i;
       offset[i]=0;
       temp[i]=-1;

       lenghtpath=0;
       pos=0;      
       p1=q->qpath[i];

       while(p1[0]!='\0')
			{
			  strcpy(str,"");
			  
			  while(p1[0]==' ' && p1[0]!='\0')
				 p1++;
			  while(p1[0]!=' ' && p1[0]!='\0')
				 {
					sprintf(str,"%s%c",str,p1[0]);
					p1++;
				 }
			  elm=atoi(str);
			  
			  sprintf(q->qtypeG[elm],"%s %d %d",q->qtypeG[elm],i,pos);
			  q->qouttable[elm]=q->lengthtables+pos;
			  //q->qouttable[elm*2+1]=pos;
			  lenghtpath++;
			  pos++;
			}
       lenghtableop[i]=lenghtpath;
       q->lengthtables=q->lengthtables+lenghtpath;
       sprintf(q->outlentable,"%s %d",q->outlentable,lenghtableop[i]);
       
     }

	/*The Intersection part*/
   /*temp stores the indices of the tables that must be unified
     start stores the number of unifications.
   */

	/*---*/


	
   //q->jop=0;
   for(i=0;i<num;i++)
     {       
       start=1;
       k=0;
       wasin[i]=-1;
       sprintf(q->qtypeG[i],"%s\0",q->qtypeG[i]);
       q->p=q->qtypeG[i];
       while(q->p[0]!='\0')
			{
			  indop=GetElementInString(q);   
			  //  printf("%++++d++++",indop);

			  pos=GetElementInString(q);
			  
			  if(q->qoperation[indop]==NULL)
				 temp[k]=worktable[indop];
			  else
				 temp[k]=indop;
			  
			  if(start!=1)
				 {
					sprintf(n,"qoutable%d",q->jop-1);
					if(temp[k-1]==temp[k] || (q->qoperation[temp[k-1]][0]=='q' && strcmp(q->qoperation[temp[k-1]],q->qoperation[temp[k]])==0)) 
					  {
						 strcpy(str1,"");
						 sprintf(str1,"SELECT qoutable%d %s %d %d",q->jop,q->qoperation[temp[k]], precpos,pos+offset[indop]);
						 /*-- -*/
						
						 strcpy(opfwrite[operator],str1);
						 numoperator[operator]=-1;							
						 operator++;
						 //fprintf(q->opfile,"%s\n",str1);
					  }
					else
					  {
						 strcpy(str1,"");
						 sprintf(str1,"INTERSECT qoutable%d",q->jop);
						 sprintf(str1,"%s %s %d",str1, q->qoperation[temp[k-1]], precpos);
						 sprintf(str1,"%s %s %d",str1,q->qoperation[temp[k]], pos+offset[indop]);


						 /*---*/
						 strcpy(opfwrite[operator],str1);
						 numoperator[operator]=-1;							
						 operator++;
						 

						 		  
						 sprintf(opfwrite[operator],"TESTUNIQUE qoutable%d  qoutable%d ",q->jop +1, q->jop);
						 						

						  q->jop++;

						 //fprintf(q->opfile,"%s\n",str1);

						 offset[indop]=offset[indop]+prec;
						 lenghtableop[temp[k]]=lenghtableop[temp[k]]+prec; 
						 lenghtableop[temp[k-1]]=lenghtableop[temp[k]];

						 numoperator[operator]=lenghtableop[temp[k]];	
						 operator++;
						 
					  }
					if(q->qoperation[temp[k]]!=NULL)
					  {
						 free(q->qoperation[temp[k]]); 
						 q->qoperation[temp[k]]=NULL;
					  }
					if(q->qoperation[temp[k-1]]!=NULL)
					  {
						 free(q->qoperation[temp[k-1]]); 
						 q->qoperation[temp[k-1]]=NULL;
					  }
					q->qoperation[temp[k-1]]=(char *) calloc(sizeof(char),(strlen("qoutable")+15));
					assert(q->qoperation[temp[k-1]]!=NULL);
					sprintf(q->qoperation[temp[k-1]],"qoutable%d",q->jop);
					worktable[temp[k]]=temp[k-1];
					temp[k]=temp[k-1];
					q->jop++;
				 }
			  prec=lenghtableop[temp[k]];
			  precpos=pos+offset[indop];
			  start++;
			  k++;
			}
       if(k==1)
			{
			  /*
				 The node is not involved in intersection or select.
			  */
			  //printf("\nk==%d indop==%d pos==%d\n",temp[k-1],indop, pos);
			  notrepeat[i][temp[k-1]]=pos;
			  wasin[i]=indop;
			  
			}
		 
     }



	
	//	for(i=0;i<num;i++)
	//printf("%d ",wasin[i]);
	/*	for(i=0;i<num;i++)
		if(wasin[i]!=-1)
		{
		k=wasin[i];			
		if(q->qoperation[k]==NULL)
		k=worktable[k];
		notrepeat[i][k]=notrepeat[i][k]+offset[wasin[i]]; 
		}
	*/

	
	run=1;
	kk=0;
	while(kk<operator)
	  {
		 if(opfwrite[kk][0]!='T')
			fprintf(q->opfile,"%s\n",opfwrite[kk]);
		 else
			{
			  strcpy(q->positions,"");
			  lt=numoperator[kk];
			  for(i=0;i<num;i++)
				 {
					if(wasin[i]!=-1 )
					  {
						 k=wasin[i];
						 if(q->qoperation[k]==NULL)
							k=worktable[k];
						 if(run==1)
							notrepeat[i][k]=notrepeat[i][k]+offset[wasin[i]]; 
						 if(notrepeat[i][k] < lt)
							{
							  sprintf(q->positions,"%s %d",q->positions,notrepeat[i][k]);
							}
					  }
				 }
			  run=2;
			  fprintf(q->opfile,"%s %s\n",opfwrite[kk], q->positions);
			}
		 kk++;
	  }
	
		 
   /********     The Creation of the output graphs    *********/
   
  
   strcpy(q->positions1,"");
   strcpy(q->positions,"");
   q->nameop=(char **) calloc(sizeof(char *), numop);
   assert(q->nameop!=NULL);
   
   for(i=0;i<numop;i++)
     {
       if(q->qoperation[i]!=NULL)
			{
			  q->nameop[i]=(char *) calloc(sizeof(char),strlen(q->qoperation[i])+1);
			  assert(q->nameop[i]!=NULL);
			  strcpy(q->nameop[i],q->qoperation[i]);
			}
       else q->nameop[i]=NULL;
     }
   CreateOutput(q->jop,numop,offset,lenghtableop,notrepeat,q);   
  
 if(q->totsubgraph==1)
     {
       strcpy(q->wildpositions, q->positions1);
       q->wildlengthtables=q->lengthtables;
	  }
   if(q->totsubgraph>1)
     {

		 
       q->p=q->positions1;
       while(q->p[0]!='\0' && q->p!=NULL)
	 {
	   pos=GetElementInString(q)+q->wildlengthtables;
	   sprintf(q->wildpositions,"%s %d",q->wildpositions,pos);
	 }
		 //  q->wildlengthtables=q->wildlengthtables+q->lengthtables;       
		 q->wildlengthtables=q->lengthtables;       

     }

   /******************* Free memory *******************************/
   
   for(i=0;i<numop;i++)
     {
       if(q->nameop[i]!=NULL) free(q->nameop[i]); q->nameop[i]=NULL;
       free(q->qoperation[i]); q->qoperation[i]=NULL;
     }
   free(q->qoperation); q->qoperation=NULL;
   free(q->nameop);

}


/* ********************************************************************** */
/*
  Check if an edge exists.
*/
/* ********************************************************************** */
int FindEdge(int *G, int i, int j, int num)
{
  int k=1;
  while(k<=G[i*num])
    {
      if(G[i*num+k]==j)
	return j;
      k++;
    }
  return -1; /* the edge does not exists*/
}

/* ********************************************************************** */
/*
  Find the 
 */
/* ********************************************************************** */
void FindMAXPath(int num, int start, int ind,int lenghtpath, int *G, char **typeG, Query q)
{  
  int k=1, j;
  
  while(k<=G[start*num])
    {
      j=G[start*num+k]; 
      if(j!=-1 && FindEdge(G,j, start,num)!=-1)
		  {
			 q->connect[j]=1;
			 sprintf(q->qpath[ind],"%s %d",q->qpath[ind],j);
			 q->dimconnect++;
			 sprintf(q->qoperation[ind],"%s%s",q->qoperation[ind],typeG[j]);
			 G[start*num+k]=-1;
			 if(lenghtpath<LengthPath)
				FindMAXPath(num,j,ind,lenghtpath+1, G, typeG,q);
			 return;
		  }
      k++;
    }
}


/* ********************************************************************** */
/*
  Store tha name of a table in q-> qoperation.
  They are the input of the algebra opeartions (see algebra5.k). 
 */
/* ********************************************************************** */
void CreateOperations(int num, int *G, int i,  char **typeG, Query q)
{
		q->connect[i]=1;
		q->qpath[q->numpath]=(char *) calloc(sizeof(char),num*1000);
		assert(q->qpath[q->numpath]!=NULL);
		sprintf(q->qpath[q->numpath],"%d",i);
		q->dimconnect++;
		q->qoperation[q->numpath]=(char *) calloc(sizeof(char),num*1000);
		sprintf(q->qoperation[q->numpath], "^%s",typeG[i]);
} 





/* ********************************************************************** */
/* Input: query graph { types and edges}
	Output : list of operations.
 */
/* ********************************************************************** */
void QueryFindOperations(int num, int *G, char **typeG, Query q)
{
  int i, j, ii;
  q->numpath=0;

  
  for(i=0;i<num;i++)
    {		
		if(G[i*num]==0) /*Checking for isolated node*/
		  {				  
			 CreateOperations(num, G, i,typeG,q);		
			 q->numpath++;
		  }
		for(j=1;j<=G[i*num];j++) /*Checking for paths*/
		  {
			 if(G[i*num+j]!=-1 && FindEdge(G, G[i*num+j],i,num)!=-1)
				{
				  q->connect[G[i*num+j]]=1;
				  CreateOperations(num, G, i,typeG,q);		
				  FindMAXPath(num, i,q->numpath,1,G, typeG,q);
				  q->numpath++;
				}
		  }
		if((i<num-1 && q->connect[i+1]==0) || (i==num-1))
		  {	
			 if (q->totsubgraph==0)
				{
				  fprintf(q->needfile,"^");
				}
			 q->totsubgraph++;
			 for(ii=0;ii<q->numpath;ii++)
				{
				  fprintf(q->needfile,"|%s",q->qoperation[ii]);
				  fprintf(q->needf1,"%s\n",q->qoperation[ii]);
				}
	 
			 FindOutputSubGraph(q->numpath,num,q);
			 for(ii=0;ii<q->numpath;ii++)
				{
				  free(q->qpath[ii]);
				  q->qpath[ii]=NULL; 
				}
			 free(q->qpath);q->qpath=NULL;
			 Inz(q, num);	
					
		  }
	 }
	 
}
/* ********************************************************************** */
/*
  Given a string "aaaaaa  bbbbbbb  cccccc"
  returns the first substring "aaaaaa".
 */
/* ********************************************************************** */
char *GetSubString(Query q)
{
  char *begin, *end;
  while(q->spit[0]==' ' && q->spit[0]!='\0')
    q->spit++;
  begin=q->spit;
  while(q->spit[0]!=' ' && q->spit[0]!='\0')
    {
      q->spit++;
    }
  end=q->spit;
  if(q->spit[0]==' ') 
	 {
		q->spit++;
	 }
  end[0]='\0';
  return begin; 
}



/* ********************************************************************** */
/*
  Check for a path between two nodes in a substructure
  connected with wildcards.
  */
/* ********************************************************************** */
int FindWildPath(Query q, char op,int *outids, int *G, int min, int max,int n1, int n2,int num, int father, int lengthpath)
{
 
  int i,j,n;

  j=0;
  while(j<num && q->flag==0)
	 {
      if(G[father*num+j]==1) 
		  {
			 n=j;
			 if((n==n2 && lengthpath==max && op=='e')||(n==n2 && lengthpath>=min && op=='g') ||(n==n2 && lengthpath<=max && lengthpath >=min && op=='l') )
				{
				  q->flag=1;
				}
			 else
				if(n!=n1 && outids[n]!=1 && (lengthpath<=1 || (lengthpath>1 && n!=q->path[lengthpath-2])))
				  { 
					 q->path[lengthpath]=n;							  
					 if(lengthpath<max )
						FindWildPath(q,op,outids,G,min, max, n1,n2,num,n,lengthpath+1);
				  }
		  }
		j++;
	 }
  return;
}




/* ********************************************************************** */
/*
  Check that the path between two nodes in a substructure
  connected with wildcards.
  not included nodes that are in the substructure.
  es: n1/././n2/n3/ we have to check that the exists a path between n1 and n2 and
  it does go through n3.
 */
/* ********************************************************************** */
void TestUniquePathWildConnection(Query q,int *outids, int *outindx,int *T, int num)
{
  listwildconnection *w;
  int n1, n2, val;
  int valid=1;


  if(q->path==NULL)
    {
      q->path=(int *)calloc(sizeof(int),num+1);
      assert(q->path);
    }

  w=q->wildhead;
  while(w!=NULL && valid==1)
    {

      if(w->info[0]!=-1 && w->info[1]!=-1)
	{
	  q->flag=0;
	  n1=outindx[w->info[0]];
	  n2=outindx[w->info[1]];
	  val=w->info[2]+1;
	  q->path[0]=n1;
	  if(w->op=='l')
	    FindWildPath(q,w->op,outids,T,1,val,n1,n2,num,n1,1);
	  else
	    if(w->op=='g')
	      FindWildPath(q,w->op,outids,T,val,num-1,n1,n2,num,n1,1);
	    else
	      {
		FindWildPath(q,w->op,outids,T,val,val,n1,n2,num,n1,1);
	      }
	  valid=q->flag;
	} 	
      w=w->next;
    }
}



/* ********************************************************************** */
/*
 Input: two nodes, a wildcard value and the shortest path matrix.
 if the shortest path between the two nodes is less then the wildcard value
 the substructures is deleted from the output.
 */
/* ********************************************************************** */
int EvaluateWildConnection(char op,int num, int i, int j, int info, int *T)
{

  if(op=='l')						  
    if(T[i*num+j]>info)
		return 0;
  if(op=='e')						  
     if(T[i*num+j]>info)
	  return 0;
  return 1;
}



/* ********************************************************************** */
/*
  The query (glide format) contains wild cards. 
  Input: the output file query_file_name.out.
  Output: the output file query_file_name.output.
  It parses query_file_name.out to select the substructures that
  satisfies the wild connections.
 */
/* ********************************************************************** */
void CheckInOutTableWildConnection(Query q, char *str1)
{
  listwildconnection *w;
  int indop, indop1, pos, j, k;
  FILE *fp, *fpout, *fpsp;
  char *output, count[20];
  int i,ii;
  int num,valid,elm;
  int *T=NULL;
  int n1, n2, iz;
  int *outids=NULL;	         /* outids[n]=1 if the node n is in answer*/	
  int oldcount=-1;
  int val;
  int *outindx=NULL;		  /* outindx[ind]=n if the node n is in the ind column -answer-out table */
  int ind;
  int sizeoutindx;


  w=q->wildhead;
  while(w!=NULL)
    {
		for(j=0;j<=1;j++)
		  if(w->info[j]!=-1)
			 {
			   
				pos = q->qouttable[w->info[j]];
				w->info[j]=pos;
			 }

		w=w->next;
	 }

  fp=fopen(str1,"r");
  assert(fp);
  q->ss = StringSetCreate(avn, avl, aves);
  StringSetInz(q->ss);
  sprintf(str1,"%s%s",str1,"put");
  fpout=fopen(str1,"w+");
  assert(fpout);


  while(!feof(fp)) 
    { 	     
      output=StringSetReadType(q->ss, fp);
      while(!feof(fp) && output[0]!='#' )
		  {
			 output=StringSetReadType(q->ss, fp);
		  }
      output=StringSetReadType(q->ss, fp);
      

      while(!feof(fp) && output[0]=='g')
		  {
			 iz=1;
			 strcpy(count,"");
			 while(output[iz]!='|') 
				{
				  sprintf(count,"%s%c",count,output[iz]);
				  iz++;
				}
#ifdef DEBUG
	  if(DBG_CHK){ DBG_MSG;
	  printf("\n%s",count);
	  }	
#endif	  

	  i=atoi(count);

	  if(i!=oldcount)
	    {
	      oldcount=i;
			
	      if(T!=NULL) free(T);
	      if(q->path!=NULL) free(q->path);

		     	      sprintf(count,"graphgrepdata/gn%d.sp",i);
	      fpsp=fopen(count,"r");
	      assert(fpsp);
	      fscanf(fpsp,"%d",&num);
	      T=(int *)calloc(sizeof(int),num*num);
	      assert(T);
	      q->path=(int *) calloc(sizeof(int),num+1);
	      assert(q->path);

	      fread(T,sizeof(int)*num*num,1,fpsp);
	      fclose(fpsp);
	    }

	  
  	  if(outindx==NULL)
		 {
			sizeoutindx=strlen(&output[iz]);
			outindx=(int*)calloc(sizeof(int),sizeoutindx);
			assert(outindx);
		 }
	  else
		 for(i=0;i<sizeoutindx;i++)
			outindx[i]=0;	

	  if(outids==NULL)
		 {
			outids=(int*)calloc(sizeof(int),q->sizeoutids);
			assert(outids);
		 }
	   else
		  if(num>q->sizeoutids)
			 {
				free(outids);
				outids=(int*)calloc(sizeof(int),2*q->sizeoutids);
				assert(outids);
			 }
		  else
			 for(i=0;i<num;i++)
				outids[i]=0;	

	  q->p=&output[iz+1];	
	  ind=0;
	  while(q->p[0]!='\0' && q->p[0]!='\n' && q->p!=NULL)
	    {
	      n1=GetElementInString(q);
	      outids[n1]=1;
	      outindx[ind]=n1; 
	      ind++;
	    }
	  valid=1;
	  w=q->wildhead;
	  
	  while(w!=NULL && valid==1)
	    {
	      if(w->info[0]!=-1 && w->info[1]!=-1)
			  {
				 valid=1;
				 //		 valid=EvaluateWildConnection(w->op,num,outindx[w->info[0]],outindx[w->info[1]],w->info[2]+1,T);
			  }
	      else
			  {
				 if(w->info[0]!=-1)
					elm=outindx[w->info[0]];
				 else
					elm=outindx[w->info[1]];
				 
				 valid=0;
				 n2=0;
				 while(n2<num && valid==0)
					{
					  if(n2!=elm)
						 valid=1;
						 //valid=EvaluateWildConnection(w->op,num,elm,n2,w->info[2]+1,T);
					  if(valid==1)
						 {
							if(q->path==NULL)
							  {
								 q->path=(int*)calloc(sizeof(int),num+1);
								 assert(q->path);
							  }
							q->path[0]=elm;
							val=w->info[2]+1;
							q->flag=0;	 /* the value is changed in FindWildPath */
							if(w->op=='l')
							  FindWildPath(q,w->op,outids,T,1,val,elm,n2,num,elm,1);
							else
							  if(w->op=='g')
								 FindWildPath(q,w->op,outids,T,val,num,elm,n2,num,elm,1);
							  else
								 FindWildPath(q,w->op,outids,T,val,val,elm,n2,num,elm,1);
							valid=q->flag;
							free(q->path);q->path=NULL;
						 }
					  n2++;
					}
			  }
			w=w->next;
	    }
	  
	  if(valid==1)
	    {
	      TestUniquePathWildConnection(q,outids,outindx,T,num); 
	      valid=q->flag;
	      if(valid==1){	      
			  fprintf(fpout,"%s",output);
	      }	
	    }
	  if(!feof(fp))  output=StringSetReadType(q->ss, fp);	 
		  }
    }
  StringSetDestroy(q->ss);
  if(outindx!=NULL) free(outindx);
  if(outids!=NULL) free(outids);
  if(T!=NULL) free(T);
  fclose(fp);
  fprintf(fpout,"\n*****\n");
  fprintf(fpout,"%s\n*****",q->outlentable);
  fclose(fpout);

}

/* ********************************************************************** */
/*
  Input: the dataset (row contains the indices of the graphs in the dataset
  after the filter).
  Output: the output files.
*/
/* ********************************************************************** */
void QueryRunAlgebra(Query q, int *row, char *str1, int dbsize)
{
  FILE *fpq;
  char str[500];
  int i, jop=0;
  char *op1, *op2, *spit;


  /*printf("algebra started");*/
  for(i=0;i<dbsize;i++)
    {
      fprintf(q->fopfile1,"gn%d\n",row[i]);

    }
  fprintf(q->fopfile1,"\n");
  fclose(q->fopfile1);       
 
  spit=q->spit; /*used to free the memory, see GetSubString*/
  if(q->totsubgraph>1) /*the query graph is disconnected */
	 {
		jop=0;
		op1=GetSubString(q);
		op2=GetSubString(q);
		fprintf(q->opfile,"CARTESIANPRODUCT qout%d %s %s\n",jop,op1,op2);
		jop=1;
		for(i=3; i<=q->totsubgraph; i++)
		  {
			 fprintf(q->opfile,"CARTESIANPRODUCT qout%d qout%d %s\n",jop, jop-1,GetSubString(q));
			 jop++;
		  }
		fprintf(q->opfile,"TESTUNIQUE qout%d qout%d %s\n",jop,jop-1,q->wildpositions);
		fprintf(q->opfile,"SPIT qout%d\n",jop);	 
	 }
  else
	 fprintf(q->opfile,"SPIT %s\n",q->spit);
  

  free(spit);
  fclose(q->opfile);
  fclose(q->needfile);
  fclose(q->needf1);
  
  system("rm need");
  system("rm need1");
  system("rm tab");
  system("rm opf");
  strcat(str1,".out");
  sprintf(str,"rm %s",str1);
  system(str);
  system("cp opfile1 need1");
  system("cat need1 neededtables > tab ");
  system("k graphgen tab"); 
  system("cat opfile1 opfile > opf");
  system("k graphgen opf");  
  system("cat opfile1 neededtables1 > need");
  system("k graphgen need");
  
  sprintf(str,"cd graphgrepdata/; k ../algebra5 MULTIOP ../tab.out ../%s ../opf.out ../need.out",str1);  
  system(str);
 
  if(q->wildhead!=NULL)
	 CheckInOutTableWildConnection(q,str1);  
  else
    {
      
      fpq=fopen(str1,"a");
      assert(fpq);
      fprintf(fpq,"\n*****\n");
      fprintf(fpq,"%s\n*****",q->outlentable);
      fclose(fpq);  
    }
  
  
}


/* ********************************************************************** */
Query QueryCreate(int num, listwildconnection *wildhead)
{

  int i;
  Query q;

  q=(Query) calloc(sizeof(struct Query_Struct),1);
  assert(q);
  
  q->num = num;
  q->qtypeG=(char **) calloc(sizeof(char *),num);
  assert(q->qtypeG!=NULL);
  
  for(i=0;i<num;i++)
    {
      q->qtypeG[i]=(char *) calloc(sizeof(char),600);
      assert(q->qtypeG[i]!=NULL);
      strcpy(q->qtypeG[i],"");
    }

  q->qoperation=(char **) calloc(sizeof(char *),num*num);
  assert(q->qoperation!=NULL);
  q->qpath=(char **) calloc(sizeof(char *),num*num);
  assert(q->qpath!=NULL);

  q->connect=(int *) calloc(sizeof(int),num);
  assert(q->connect!=NULL);
  q->dimconnect=0;

  q->opfile=fopen("opfile","w+");
  assert(q->opfile);

  q->needf1=fopen("neededtables1","w+");
  assert(q->needf1);
  q->needfile=fopen("neededtables","w+");
  assert(q->needfile);
  
  q->fopfile1=fopen("opfile1","w+");
  assert(q->fopfile1);
   
  q->jop=0;
  q->spit=(char *)calloc(sizeof(char),20*num);
  assert(q->spit!=NULL);
  strcpy(q->spit,"");
  q->totsubgraph=0;

  q->wildhead = wildhead;

  q->qouttable = (int *) calloc(sizeof(int),num);
  assert(q->qouttable!=NULL);
  
  q->path=NULL;
  q->sizeoutids=1000;
  return q;
}

/* ********************************************************************** */
void QueryDestroy(Query q)
{    
  int i;
  for(i=0;i<q->num;i++)
	 if(q->qtypeG[i]!=NULL) free(q->qtypeG[i]);
  free(q->qtypeG);
   free(q->qpath);
  free(q->qoperation);
  free(q->connect);
  if(q->path!=NULL) free(q->path);
  free(q->qouttable);
  free(q);

  
}






