#include "graph.h"

////////////////////////////////////////////
//
// Class: vDFS_GraphBuild
// Usage: GraphBuild main class. Doing DFS traversal and store all patterns found.
//
/////////////////////////////////////////////
template <class GraphADT> class vDFS_GraphBuild
{
	GraphADT &G;			//The Graph reference need to be visited
	DEGREE<GraphADT> degree;	//Degree information of this graph

	//data used in DFS travseral
	int cnt,LP,curLP;			
	int pathcount,backEdge;

	NodeType* pathstack;		//Stack contains nodes of the current path
	NodeType* NodeDegree;		//Stack contains degree of nodes in the current path
	string strNodeLabel;		//String contains lable of nodes in the current path
	string strNodeDegree;		//String contains degree of nodes in the current path

	fingerprint fp;				//fingerprint of this graph

	int DegreeCount;			//tmp variable for degree count
	int tablecount;				//tmp variable for table count

	//Checking if this edge already visited in the current path
	bool checkEdgeVisited(Edge e){
		if(curLP>3){  //no possible looping(1-2-3-1) for nodes less than 4(lp<=3), because already check parent-edge before
			for(int i=1;i<curLP;i++){	//checking all nodes in the path-stack
				NodeType n1,n2;

				n1=pathstack[i-1];
				n2=pathstack[i];

				if(e.v==n1 && e.w==n2)
					return true;
				else if(e.w==n1 && e.v==n2)
					return true;
			}
		}
		return false;
	}

	//Data-structure store all the Label-Path(pattern) data
	Map_PathTableWithDegree* myDegreePathMap;
	Map_PathTable* myPathMap;

	//output a path of given LengthPath
	void outputPath(int lp){		
		pathcount++;

		string tablename(G.getName());
		tablename+=strNodeLabel;

		unsigned int FP=fp.addPattern(strNodeLabel);

		if(QUERY_WITH_DEGREE){
			Map_PathTableWithDegree::iterator it=(*myDegreePathMap).find(tablename);

			if( it!=(*myDegreePathMap).end()){
				(*it).second->insert(strNodeDegree,pathstack);
			}else{
				PathTableWithDegree *myPathTab=new PathTableWithDegree(tablename,lp);			
				myPathTab->insert(strNodeDegree,pathstack);
				(*myDegreePathMap).insert(Map_PathTableWithDegree::value_type(tablename,myPathTab));
				tablecount++;
			}		
		}else{			
			Map_PathTable::iterator it=(*myPathMap).find(tablename);
			if( it!=(*myPathMap).end()){
				(*it).second->insertData(pathstack);
			}else{
				PathTable *myPathTab=new PathTable(tablename,lp);
				myPathTab->insertData(pathstack);
				(*myPathMap).insert(Map_PathTable::value_type(tablename,myPathTab));
				tablecount++;
			}		
		}
	}

	//show the element of input vector
	void show(const vector<int>& out){
		cout<<"#path:";
		
		for(int j=0;j<out.size();j++){
			cout<<out[j]<<" ";
		}
		cout<<endl;	
	};

	//DFS traversal(right side)
	void dfsR(Edge e);

public:
	//Constructor
	// Params: 1. GraphADT Object 
	//         2. Lengthpath 
	vDFS_GraphBuild(GraphADT&,int LP);

	//Destructor
	~vDFS_GraphBuild();
	
	//Get the PathTable(with degree) of this graph
	Map_PathTableWithDegree* getMapDegreePathTable(){return myDegreePathMap;};
	//Get the PathTable of this graph
	Map_PathTable* getMapPathTable(){return myPathMap;};
	//Get the fingerprint of this graph
	unsigned int* getFingerPrint(){return fp.getFP();};
};

/////////////////////////////////////////////////////////////
//	
//	Implementation detail of vDFS_GraphBuild templete class. 
//	Put here because of templete limitation
//
/////////////////////////////////////////////////////////////

//DFS travesal of this graph, starting from a given edge
template <class GraphADT>
void vDFS_GraphBuild<GraphADT>::dfsR(Edge e){
	int w=e.w;
	
	//Node position information
	pathstack[curLP]=w;
	
	//Degree information
	char num[5];			
	NodeDegree[curLP]=degree[w];
	sprintf(num,"%d",degree[w]);
	
	int oldDegreeLen=strNodeDegree.size();
	strNodeDegree +=" ";
	strNodeDegree +=num;
	
	//degree count
	DegreeCount+=degree[w];		
	
	//Label information
	int oldLabelLen=strNodeLabel.size();
	strNodeLabel +=G.getLabel(w);
	
	typename GraphADT::adjIterator A(G,w);
	
	int ichild=0;
	bool isOverLP=false;
	bool isEdgeExist=false;
	
	for(int t=A.beg();!A.end();t=A.nxt())
	{
		if(t!=e.v){
			Edge x(w,t);
			
			ichild++;
			curLP++;
			
			if(curLP>=(LP+1)){		//if over the LP limitation, output it
				outputPath(curLP);
				isOverLP=true;
				isEdgeExist=false;
				
				curLP--;
				break;	
			}else if(checkEdgeVisited(x)){	 //this edge already exist in the current path, go another sibling
				isEdgeExist=true;
				
				curLP--;
			}else{
				dfsR(x);		//no matter what ... keep going down
			}
		}
	}
	
	//Check if need to output path
	if(ichild==0 && curLP>=1){	//leaf node
		outputPath(curLP+1);
	}else{
		if(isEdgeExist &&!isOverLP){	//looping, outputing it and setting backEdge count
			outputPath(curLP+1);
			backEdge++;
		}else if(ichild>0 && !isOverLP){	
			outputPath(curLP+1);
		}
	}
	
	curLP--;
	DegreeCount -=degree[w];
	
	strNodeLabel = strNodeLabel.substr(0,oldLabelLen);
	strNodeDegree = strNodeDegree.substr(0,oldDegreeLen);		
}

//Constructor
// Params: 1. GraphADT Object 
//         2. Lengthpath 
template <class GraphADT>
vDFS_GraphBuild<GraphADT>::vDFS_GraphBuild(GraphADT &G,int lp):G(G),degree(G),curLP(0),LP(lp),cnt(0),pathcount(0),backEdge(0),tablecount(0),DegreeCount(0),fp(NUM_INTS)
{	
	//allocate mem data member
	pathstack=new NodeType[LP+1];
	NodeDegree=new NodeType[LP+1];		  
	
	//create pathtable
	if(QUERY_WITH_DEGREE)
		myDegreePathMap=new Map_PathTableWithDegree();
	else
		myPathMap=new Map_PathTable();
	
	//call DFS traversal, start from node 0
	for(int v=0;v<G.V();v++){
		if(degree[v]>0){
			dfsR(Edge(v,v));
		}else if(degree[v]==0){	//output the single node
			strNodeLabel +=G.getLabel(v);
			pathstack[0]=v;	
			outputPath(1);
			
			strNodeLabel=string("");
		}	
		curLP=0;
	}
	//screen out
	if(!QUIET_MODE){
		cout<<"total path:"<<pathcount<<"\n";
		cout<<"total backEdge:"<<backEdge<<"\n";
		cout<<"total table:"<<tablecount<<"\n";
	}
}

//Destructor
template <class GraphADT>
vDFS_GraphBuild<GraphADT>::~vDFS_GraphBuild(){
	delete pathstack;
	delete NodeDegree;
	
	if(QUERY_WITH_DEGREE){
		Map_PathTableWithDegree::iterator it=myDegreePathMap->begin(),
			it_end=myDegreePathMap->end();
		
		for(it;it!=it_end;it++){
			delete (*it).second;
		}
		
		delete myDegreePathMap;
	}else{
		Map_PathTable::iterator it=myPathMap->begin(),
			it_end=myPathMap->end();
		
		for(it;it!=it_end;it++){
			delete (*it).second;
		}
		
		delete myPathMap;		
	}
}
