from collections import Counter

"""
def closest_three(info):
    counts = Counter(info['items'])
    # -> { "Picasso": # of picasso, VG: ... }
    by_count = []
    for artist, count in counts.items():
        ratio = count / len(info['items'])
        by_count.append((ratio, artist))
    by_count.sort(reverse=True)
    # print(by_count)
    ratio2, artist2 = by_count[1]
    # print(artist2)
    return artist2
"""

def indices_of_artists(info):
    artists = info['item_types']
    indices = {a: [] for a in artists}
    for i, item in enumerate(info['items']):
        indices[item].append(i)
    # print(indices)
    return indices

sample_info = {
    "cur_round": 10,
    "history": [
        {"bid": 76, "item": "Van_Gogh", "player": "charlie"},
        {"bid": 79, "item": "Da_Vinci", "player": "bob"},
        {"bid": 11, "item": "Van_Gogh", "player": "bob"},
        {"bid": 92, "item": "Da_Vinci", "player": "alice"},
        {"bid": 2, "item": "Picasso", "player": "bob"},
        {"bid": 10, "item": "Picasso", "player": "charlie"},
        {"bid": 9, "item": "Van_Gogh", "player": "charlie"},
        {"bid": 6, "item": "Picasso", "player": "bob"},
        {"bid": 6, "item": "Rembrandt", "player": "alice"},
        {"bid": 3, "item": "Picasso", "player": "charlie"},
    ],
    "item_types": ["Picasso", "Van_Gogh", "Rembrandt", "Da_Vinci"],
    "items": [
        "Van_Gogh",
        "Da_Vinci",
        "Van_Gogh",
        "Da_Vinci",
        "Picasso",
        "Picasso",
        "Van_Gogh",
        "Picasso",
        "Rembrandt",
        "Picasso",
        "Picasso",
        "Da_Vinci",
        "Da_Vinci",
        "Van_Gogh",
        "Van_Gogh",
        "Van_Gogh",
        "Rembrandt",
        "Van_Gogh",
        "Rembrandt",
        "Van_Gogh",
        "Rembrandt",
        "Rembrandt",
        "Picasso",
        "Picasso",
        "Picasso",
        "Rembrandt",
        "Rembrandt",
        "Da_Vinci",
        "Da_Vinci",
        "Rembrandt",
        "Van_Gogh",
        "Da_Vinci",
        "Picasso",
        "Da_Vinci",
        "Rembrandt",
        "Picasso",
        "Rembrandt",
    ],
    "others": [
        {
            "budget": 2,
            "item_count": {"Da_Vinci": 1, "Picasso": 2, "Rembrandt": 0, "Van_Gogh": 1},
            "name": "bob",
        },
        {
            "budget": 2,
            "item_count": {"Da_Vinci": 1, "Picasso": 0, "Rembrandt": 1, "Van_Gogh": 0},
            "name": "alice",
        },
    ],
    "self": {
        "budget": 2,
        "item_count": {"Da_Vinci": 0, "Picasso": 2, "Rembrandt": 0, "Van_Gogh": 2},
        "name": "charlie",
    },
    "type": "info",
}

# closest_three(sample_info)
indices_of_artists(sample_info)


def dennis_fmt(info):
    """
    converts info to Dennis' format

    itemsinauction is a list where at index "rd" the item in that round is being sold is displayed.

    winnerarray is a list where at index "rd" the winner of the item sold in that round is displayed.

    winneramount is a list where at index "rd" the amount of money paid for the item sold in that round is displayed.

    example: I will now construct a sentence that would be correct if you substituted the outputs of the lists:
    In round 5 winnerarray[4] bought itemsinauction[4] for winneramount[4] dirhams/dollars/money unit.

    numberbidders is an integer displaying the amount of people playing the auction game.

    players is a list containing all the names of the current players.

    mybidderid is a string that contains your name.

    artists is a list containing all the names of the artists (paintings) that are for sale in our auction.

    standings is a set of nested dictionaries (standings is a dictionary that for each person has another dictionary
    associated with them). standings[name][artist] will return how many paintings "artist" the player "name" currently has
    standings[name]['money'] (remember quotes for string, important!) returns how much money the player "name" has left.
    If you want to access information about yourself use standings[mybidderid][(name of artist)/'money']

    rd is the current round in 0 based indexing.
    """
    itemsinauction = info["items"]
    winnerarray = [x["player"] for x in info["history"]]
    winneramount = [x["bid"] for x in info["history"]]
    numberbidders = len(info["others"]) + 1
    all_p = info["others"] + [info["self"]]
    players = [p["name"] for p in all_p]
    mybidderid = info["self"]["name"]
    artists = info["item_types"]
    standings = []
    for p in all_p:
        d1 = {artist: p["item_count"][artist] for artist in artists}
        d1.update({"money": p["budget"]})
        standings.append(d1)
    rd = info["cur_round"]
    return (
        itemsinauction,
        winnerarray,
        winneramount,
        numberbidders,
        players,
        mybidderid,
        artists,
        standings,
        rd,
    )


def compute_bid_state(info, prev_state):
    """
    TODO: complete this function to determine the best bid.
    >>> compute_bid(sample_info)
    2
    """
    # convert info to Dennis' format
    # you are free to apply further preprocessing to make your life easier
    (
        itemsinauction,
        winnerarray,
        winneramount,
        numberbidders,
        players,
        mybidderid,
        artists,
        standings,
        rd,
    ) = dennis_fmt(info)
    
    rd = info["cur_round"]
    biddinghistory = []

    # if no budget we withdraw early from the bid
    if info['self']['budget'] == 0:
        biddinghistory.append(0)
        bid = 0
        return bid, None
    
    # if i have two of one artist bid all my money on the next round
    if info["self"]["item_count"][info["items"][rd]]  == 2:
        bid = info["self"]["budget"]
        return bid, None

    # FPSB: if there are two bidders we just bet half our budget every round then we should win the first three rounds so we win no?
    
    if numberbidders == 2:
        
            # do we want to bed half every round? or do we want to choose which round to bet on
            bid = info["self"]["budget"] * 0.5
            bid = round(bid)
            print(f"bidding ${bid} for a", info["items"][rd])
            return bid, None

    # if there's more than two players we don't bet on the first round
    else:
        if rd != 0:
        
        # if there are more than two we bet on the items that come after the earliest recurring artist: 
        # for instance in sample info every time after Van Gogh we bet some amount of money : so on items of index 1 3 7 14 
        # otherwise we don't participate on the bet 

        # need to decide the set of items we want to buy
            artistindex = indices_of_artists(info)
            third_artists = []
            for artist, indices in artistindex.items():
                third = indices[2] if len(indices) >= 3 else 1234
                third_artists.append((third, artist))
            min_third, min_artist = min(third_artists)
            before_indices = artistindex[min_artist]
            
            if rd-1 in before_indices:
                # explain why we chose 20
                bid = 20
                return bid, None
            
    return 0, None

