/ Solve the sudoku game
/ Given a game matrix having numbers and 0s,
/ try to find a solution.

difference:{[x;y]
 x where not x in y}

/ returns fail if some 0 can't be replaced by anything
/ returns success if there is some location that has exactly one possible value.
/ returns alldone if no location are 0
/ returns a location and a set of possible values if every location
/ has at least two possible continuation values
findnext:{[m]
 done: 1;
 i: 0;
 triallocx: -1;
 triallocy: -2;
 trialposs: 1+til 9;
 while[i < 9;
   j: 0;
   while[j < 9;
	if[0 = m[i;j];
		done: 0;
		x: findposs[i; j; m];
		if[0 = count(x); :(`fail; m)];
		if[1 = count(x); 
			newm: m;
			newm[i;j]: first x;
			:(`success; newm)
		];
		if[(count(x)) < count(trialposs);
			triallocx: i;
			triallocy: j;
			trialposs: x;
		];
	j+: 1;
   ];
   i+: 1;
 ];
 if[done = 1; :(`alldone; m)]; / no 0s left
 if[done = 0; :(`trial; m; triallocx; triallocy; trialposs)]; 
	/ some location with a fairly small number of possibilities
 }

/ find the possible value that could be assigned to row locx 
/ and col locy
/ return 0 if already taken
findposs:{[locx; locy; m]
  if[m[locx; locy] > 0; 2 + `x]; / should not happen
  x: m[locx];
  x,: m[;locy];
  nearestleft: 3 * floor (locy+1) % 3;
  nearesttop: 3 * floor (locx+1) % 3;
  x,: m[nearesttop; nearesttop+til 3];
  x,: m[nearesttop+1; nearesttop+til 3];
  x,: m[nearesttop+2; nearesttop+til 3];
  valstaken: distinct x[where x > 0];
  :difference[wholeset; valstaken]
  }
  

/ DATA
wholeset: 1 + til 9;
movestack: (); / consists of triples, row/col location and value
s:(0 0 1 3 4 0 7 9 2;
   2 0 7 0 0 0 0 8 0;
   0 0 0 0 0 0 0 0 0;
   0 0 0 0 0 0 0 0 0;
   0 0 0 0 0 0 0 0 0;
   0 0 0 0 0 0 0 0 0;
   0 0 0 0 0 0 0 0 0;
   0 0 0 0 0 0 0 0 0;
   0 0 0 0 0 0 0 0 0)
   
