/ https://code.kx.com/trac/wiki/QforMortals2/primitive_operations
/ https://code.kx.com/trac/wiki/QforMortals2/built_in_functions

/ This file contains basic operations and how to do them in q
/ I strongly recommend that 
/ you try these one line at a time in the interpreter.
/ It will help you internalize frequently used operators and adverbs

/ Arithmetic:

5 * 6 / scalar mult

(5 6 7) * 3 / vector * scalar mult

(5 6 7) * (1 2 3) / vector mult -- arguments must be the same length

(5 6 7) % (1 2 3) / vector division -- note that division is %

/ Generating data

til 10 / whole numbers from 0 to 9

5 + til 10 / generate first and then add 5 to each element

10 ? 20 / 10 numbers drawn from 20 at random with replacement

(-10) ? 20 / 10 numbers drawn from 20 at random without replacement

10 ? 06:00:00 / 10 random times over 6 hours

10 ? `a`bbb`c / 10 random symbols from `a `bbb `c

/ starting at a random seed determined by current time
t: ltime .z.p / current datetime locally
millis: `int$t.time / milliseconds
x: (millis mod 767) ? 20
/ Now can use a random number as you like
possiblestocks: `ibm`hp`aapl`goog
first 1 ? possiblestocks

/ arrays and lists

x: 12 ? 06:00:00 
y: 12 ? 300
z: x,y / two lists can be concatenated together

x[2 4] / lists can be indexed like arrays

z[4 18 15] / index lists even of mixed types


m: max y

y ? m / find index of max element in y

y[y ? m] / just checking that we've found the max

x[y ? m] / find time corresponding to index of max element of y

asc x / sort a list

iasc x / find the permutation that would give the sort

x[iasc x] / net effect is to sort x

y[iasc x] / net effect is to sort y based on ordering of x

(asc x),'(y[iasc x]) / concatenate pairs in order


sum y

sums y / running sums

sums y[iasc x]

x[where y > 175] / indexes in x give selection in y

sums y[where x > 02:00:00] / notice how operators go from right to left
	/ unless there are parens

z: 50 ? 8 / 50 numbers with replacement from 0 through 7 inclusive

g: group z / group them

key g

value g

(key g),'(count each value g)

/ find greatest index of each key value




/ string manipulation

s: "i am a string."

s[11] / index into the string

s[0 4 6] / multiple indexes into the string

s,s / concatenate strings

s,\: "&" / append blank to each character in s and get many lists

s,\: "1 2 3" / append several numbers after each character in s

raze s,\: " " / append blank to each character in s and then put lists together

raze (" "),/: s / figure out how this is different from previous

s ss " a" / looking for indexes of space followed by a

s like "*rin*" / does the string "rin" exist anywhere?

ssr[s;"trin";"un"] / replace trin by un in s

/ replace the first instance of a string with a new string
replacefirstamol:{[s; firststring; newstring]
   ii: s ss firststring;
   if[0 = count ii; :s];
   out: s[til ii[0]], newstring, ((count firststring) + ii[0]) _ s;
   :out}

/ basic functions

/ indent the name and outdent the other lines
/ semi-colon after each line except the last one
/ return value preceded by colon (:)
foo:{[a;z]
 x: a+2*z; / semi-colon after each line
 if[a < z; :x]; / return value preceded by colon; use of if
 i: 0; 
 while[i < 10;
  x: x+5; / add 5 to x
  i+: 1; 
 ];
 x}  / last line doesn't need a semi-colon

foo[5;10]

foo[10;5]

foo2:{[a;z]
 x: a+2*z; / semi-colon after each line
 if[a < z; :x]; / return value preceded by colon; use of if
 i: 0; 
 while[i < 10;
  x: x+5; / add 5 to x
  i+: 1; 
 ];
 x};  / last line doesn't need a semi-colon

foo2[5;10]
foopair:{[mypair] foo[mypair[0]; mypair[1]]}

x: 5 ? 10
y: 10 +  5 ? 20

x,'y / pairwise each is just a '

foopair each x,'y / single argument each (monadic) is the word "each"

x,/:\:y / cross-product

raze x,/:\:y / cross-product all at top level

foopair each raze x,/:\:y / try to figure out what is going on


/ Matrix multiply

m1: (1 2 3; 4 5 6; 7 8 9)

m2: (10 20; 30 40; 50 60)

m1[0]
m2[;1] / column value

dotprod:{[x;y] sum x * y}

mymatmult: {[m1;m2] m1 dotprod/:\: flip m2}



/ max length of vector is 2 billion 

/ maximum of 32 global references per function

/ maximum of 23 local variables per function

/ maximum of 96 constants within a function

/ maximum of eight function parameters




