/ find all the ancestors of a given part
findanc:{[startpart]
 out: enlist startpart;
 outqty: ();
 parents: mypartsuperlist[startpart][`slist]; / just get parts
 if[0 = count parents; :()];
 allanc: raze findanc each parents;
 items: allanc;
 items,: parents;
 out,: distinct items;
 :out;
 }


/ This improves parts explosion by keeping track of previous results
/ thus shortening recursive calls.
/ find all descendants of a given part
finddesc:{[startpart]
 if[startpart in partexp[;0]; 
	i: partexp[;0] ? startpart;
	:1 _ partexp[i]];
 out: ();
 outqty: ();
 children: mypartsublist[startpart][`slist]; / just get parts
 childqtys: mypartsublist[startpart][`qlist]; / just get quantities
 if[0 = count children; :(();())];
 allpairs: finddesc each children;
 items: raze allpairs[;0];
 qtys: raze childqtys * allpairs[;1];
 items,: children;
 qtys,: childqtys;
 mypart: value group items;
 out: distinct items;
 outqty: sum each qtys[mypart];
 partexp,: (startpart; out; outqty);
 :(out; outqty);
 }

/ EXECUTION

partexp:enlist (`none;(());())
numparts: 50
percentage: 0.6
parts: ` $' raze each (enlist "part"),/: string til numparts
descs: ` $' raze each (enlist "desc"),/: string til numparts
mypart:([]parts; description:descs);

pairs: (til count parts) cross (til count parts);
partpairs: parts[pairs[where pairs[;0] > pairs[;1]]];
numrows: floor percentage * count partpairs;
partpairs: (neg numrows) ? partpairs;
mypartpar:([]part:partpairs[;0]; subpart:partpairs[;1]; qty:1+numrows ? 10);




/ mypart: ("SS"; enlist ",") 0: `part.csv
/ mypartpar: ("SSF"; enlist ",") 0: `partpar.csv

mypartsublist: select slist: subpart, qlist: qty by part from mypartpar
mypartsuperlist: select slist: part by subpart from mypartpar

/ show mypartsublist
/ show mypartsuperlist

finddesc[first 1 ? parts]
/ findanc[first 1 ? parts]





