/ The idea of this code is that an aquery statement comes in and 
/ q code comes out.
/ This code deals with multi-table queries having foreign key relationships.

/ This will work in two passes: the first pass will take the multi-table
/ query and transform it to a single table query.
/ The second part will do normal single table processing.
/ Here is how this will work:
/ We will look at foreign key relationships and see whether they are
/ in good form. For example, for foreignkey[R.X; S.Y] X and S must be
/ the same name. Generate a comment that Y must be the key of S.
/ Next, if S and R are mentioned at all, then there must be the clause
/ R.X = S.Y. This clause will then be eliminated from the query.
/ Overall: we support only star schemas, so the left table of all the
/ foreign keys must be R.
/ Finally, we should eliminate the "fact table" (R in our running example
/ from clauses. Otherwise there is no more to do.
/ When we get away from star schemas, then we need to trace a path
/ from the root (which we must find) to each table, 
/ e.g. Q.att becomes S.T.Q.att if we have:
/ ac) foreignkey[R.S; S.keyofS] 
/ ac) foreignkey[S.T; T.keyofT]
/ ac) foreignkey[T.Q; Q.keyofQ]

/ Basic aquery stuff:
/ Here is the basic setup:
/ select [func] c1, ... cn from tab [assuming c1, c2...] 
/ where where_clause group by group_clause 
/ --> select 
/ --> for each ci if just a column then print the column, but if ci as x
/ then translate to x: ci
/ we are assuming the same functions are used
/ --> if group_clause is not empty, then ("by "), group_clause
/ --> from tab doesn't change but if there is an assuming then xasc or xdesc
/ --> where_clause -- add an extra level of parens around each subclause
/ where a subclause is delimited by an and/or and replace and by comma.
/ I think that having is a separate query.

/ Find lines that begin with a) for aquery.
/ Break down into projections, table formation (select correct columns
/ and sort if there is an assuming)

/ What remains to be done in the case of an assuming clause is to 
/ sort only the subset of the columns table that are needed. 

/ BASICS

spit:{[list] (-1) _ raze (string list),\: (" ")}
spitback:{[list] ("`"), (-1) _ raze (string list),\: ("`")}
spitcomma:{[list] (-1) _ raze (string list),\: (",")}


intersect:{[x;y] x[where x in y]}

difference:{[x;y]
 x where not x in y}



/ deletes all blanks
delblanks:{[x]
 ii: where not x = " ";
 x[ii] }

/ separate into words
sepwords:{[x]
  ii: where x in " =><(),";
  ii: distinct 0, ii;
  ii: asc ii;
  y: delblanks each ii _ x;
  c: count each y;
  ii: where not c = 0;
  ` $' y[ii]}

trimsemi:{[line] line[where not line = ";"]}

/ APPLICATION-SPECIFIC

foreignkeypairs: ()

/ process an ac) line to get a pair
/ e.g. ac) foreignkey[R.x; x.y]
processforeignkey:{[line]
  i: line ? ")";
  myline: (i+1) _ line; 
  j: myline ? "[";
  myline: (j+1) _ myline;
  j: myline ? ";";
  myfirst: ` $ ltrim rtrim myline[til j];
  myline: (j+1) _ myline;
  j: myline ? "]";
  mysecond: ` $ ltrim rtrim myline[til j];
  foreignkeypairs,: enlist (myfirst; mysecond) ;
  :()}

/ take a line of aquery and modify it based on 
/ foreignkeypairs and other data structures
editforeignkey:{[line]
  / foreignkeypairs:: (); / done with this
  x: foreignkeypairs + 5;
 line}

/ find the clauses of a line that begins with 
/ "a)" from aquery syntax into kdb syntax
/ should be in a single line without subqueries for now
/ Also look for preparatory lines beginning with ac
findclauses:{[line]
  if[3 > count line; globalout,: enlist line; :()];
  if[("ac)") ~ line[til 3]; x: processforeignkey[line]; :()];
  if[not ("a)") ~ line[til 2]; globalout,:enlist line; :()];
  myline: editforeignkey trimsemi 2 _ line; 
	/ cannot just lowercase this because field names may be case-sensitive
  iselect: myline ss "select";
  iselect,: myline ss "SELECT";
  iselect: asc iselect;
  ifrom: myline ss "from" ;
  ifrom,: myline ss "FROM" ;
  ifrom: asc ifrom;
  iwhere: myline ss "where";
  iwhere,: myline ss "WHERE";
  iwhere: asc iwhere;
  igroup: myline ss "group by";
  igroup,: myline ss "GROUP BY";
  igroup: asc igroup;
  if[0 = count iselect; :("a) No select: "), myline];
  if[0 = count ifrom; :("a) No from: "), myline];
  prefix: myline[til iselect[0]]; / the beginning
  selectclause: myline[(7 + iselect[0]) + til ((ifrom[0]) - (7 + iselect[0]))];
  if[0 < count iwhere;
   fromclause: myline[(5 + ifrom[0]) + til ((iwhere[0]) - (5 + ifrom[0]))]];
  if[0 = count iwhere;
   fromclause: (5 + ifrom[0]) _ myline];
  whereclause: " ";
  groupclause: " ";
  if[(0 < count iwhere) & (0 < count igroup);
   whereclause: myline[(6 + iwhere[0]) + til ((igroup[0]) - (6 + iwhere[0]))];
   groupclause: (9 + igroup[0]) _ myline;];
  if[(0 < count iwhere) & (0 = count igroup);
   whereclause: (6 + iwhere[0]) _ myline];
  p: createkdb[myline;prefix;selectclause;fromclause; whereclause; groupclause];
  x: p[0];
  if[(first last rtrim line) = ";"; x,: ";"];
  globalout,: enlist x;
  if[1 < count p[1]; globalout,: p[1]];
  ()}


/ generate a kdb phrase
createkdb:{[myline; prefix; selectclause; fromclause; whereclause; groupclause]
 outline: buildprefix[prefix];
 outline,: buildselect[selectclause];
 if[2 < count groupclause; outline,: buildgroup[groupclause];];
 trip: buildfrom[myline; fromclause];
 outline,: trip[0];
 if[2 < count whereclause; outline,: buildwhere[whereclause];];
 nextline: trip[1];
 mytab: trip[2];
 nextline,: enlist ("/ Replace \"" ), outline, ("\" by ");
 x: ("(select <whatever is in x> from "), mytab, (")");
 newoutline: ssr[outline; mytab; x];
 nextline,: enlist ("/ "), newoutline;
 (outline; nextline)}

/ this is the text before the select.
/ If it contains an insert, translate this to an assignment.
/ else return the prefix directly.
buildprefix:{[prefix]
 iinsert: prefix ss "insert";
 iinsert,: prefix ss "INSERT";
 iinsert: asc iinsert;
 if[0 = count iinsert; :ltrim prefix];
 myline: (6 + iinsert[0]) _ prefix;
 tablename: (rtrim ltrim myline);
 ("`"), tablename, (" insert ")}


/ everything between select and from
buildselect:{[selectclause]
 out: "select ";
 if[("*") in selectclause; :out];
 myclause: selectclause;
 j: myclause ? ",";
 while[j < count myclause;
	out,: (processcol myclause[til j]),(", ");
	myclause: (j+1) _ myclause;
 	j: myclause ? ",";];
 out,: processcol myclause;
 out}

/ a single column expression e.g. mins a as x
processcol:{[col]
  ias: col ss "as";
  if[0 = count ias; :col]
  afteras: rtrim (3 + ias[0]) _ col;
  out: afteras, (": "), rtrim col[til ias[0]];
  out}



/ everything between from and either the end or the where
buildfrom:{[myline; fromclause]
  out: " from ";
  iassume: fromclause ss "assuming";
  iassume,: fromclause ss "ASSUMING";
  iassume: asc iassume;
  if[0 = count iassume; :(fromclause, ())];
  afterassuming: ltrim rtrim (9 + iassume[0]) _ fromclause;
  icomma: where afterassuming = ",";
  if[0 < count icomma; afterassuming[icomma]: "`"];
  afterassuming: delblanks afterassuming;
  out,:("(`"),afterassuming,(" xasc ");
  mytab: (rtrim fromclause[til iassume[0]]); / this is the whole table
  out,: mytab,(")"); / this is the whole table
  words: sepwords[myline];
  reserved: `group,`by,`from,`select,`where,`and,`or,(`$">"),(`$",");
  reserved,: `GROUP,`BY,`FROM,`SELECT,`WHERE,`AND,`OR;
  reserved,: `insert,`as,`assuming,(`$"<"),(`$"=");
  reserved,: `INSERT,`AS,`ASSUMING;
  reserved,: ` $ mytab;
  words: difference[words; reserved];
  jj: where not  ((string each words)[;0]) in\: "0123456789";
  words@: jj;
  nextline: enlist ("/ Above is naive translation from aquery ");
  nextline,: enlist ("/ If table "), mytab,(" has many columns, you can make");
  nextline,: enlist ( "/ this more efficient by executing the following three lines");
  nextline,: enlist ("intersect:{[x;y] x[where x in y]}");
  nextline,: enlist ("spitcomma:{[list] (-1) _ raze (string list),\\: (\",\")}");
  nextline,: enlist ("x: spitcomma intersect[cols "),mytab, ("; "), (spitback distinct words),("];");
  (out; nextline; mytab)}

/ everything after the group by clause
buildgroup:{[groupclause]
  (" by "), groupclause}

/ just replace and or AND by ,
buildwhere:{[whereclause]
 whereclause: ssr[whereclause;" and";","];
 whereclause: ssr[whereclause;" AND";","];
 (" where "),whereclause}
 

  

	
  
/ EXECUTION

("Need an argument file, e.g. q aquery.q tmp.q")

if[0 = count .z.x; til -3] / should have a .q file
file: .z.x[0]

linenum: 0
a: read0 ` $ (":"),file

globalout: () / collect everything here
b: findclauses each a

outfile: (file[til (file ss ".q")[0]]),("_ready.q")

(` $ (":"),outfile) 0: globalout




/ line: "a) select price as myprice, time as mytime  from rantrade assuming time where price > 200 and amount < 400 group by stock";
/ x: findclauses line

