\d .u

w:([table:`symbol$(); handle:`int$()]; symlist:0h$());     //  Subscription list; keys is tables and values are clients
t:(`trade`quote`splits`insurance);                                                   // Tables defined in this q process

// Initialize .u.t and .u.w
init:{ t::tables[]; hclose each exec handle from .u.w; delete from `.u.w}

// Override .z.pc to clean up .u.w on client disconnects
del:{[tbl;hndl] delete from `.u.w where handle=hndl,table=tbl }
.z.pc:{del[;x] each t}

// Selection criteria for message publishing - sym column must be defined in all messages
sel:{[recs;syms]
        res:$[syms ~ enlist `; recs; select from recs where sym in syms];
        :res;
  }

// Publish method to iterate through all clients and call upd on them remotely
pub:{[t;x]
        {[t;x;h]
           x:sel[x; .u.w[t,h]`symlist];
           if[0<count x; (neg h)(`upd;t;x)] }[t;x] each exec distinct handle from .u.w where table=t;
  }

// Subscription method for the clients to call
// Will add the clients to .u.w
sub:{[tbls;syms]
        // if `, subscribe this handle to all tables
           if[tbls~`; :sub[;syms] each t];

        // if the table does not exist return to the client the name of this table
           if[not all tbls in\:t; 'tbls];

        // Add the new subscription info to .u.w (will override the old one for this table/handle)
        cnt:count tbls;
        if[-11h = type syms; syms:enlist syms];
        `.u.w upsert  flip  (tbls;cnt#.z.w;cnt#enlist syms);
        // Return the schemas from .u.t to the client
        :{(x; get x)} each tbls;
 }


// will iterate through client list and invoke .u.end on them remotely
end:{{(neg x) ".u.end[]"  } each exec distinct handle from .u.w}

deltick:{value "delete from `",(string x);}




\d .

