
perm:{[list] list[(neg count list) ? (count list)]}


/ given a difference diff and that the list with the larger
/ average comes first and is of length greateravglistllen
/ and the third argument is the total list, do 1000 random shuffles
/ and find out how many times the average of the firstlistlen elements
/ less the average of the rest of the elements is greater than diff.
findpval:{[diff; firstlistlen; totlist]
 out: ();
 do[1000;
   mylist: perm[totlist];
   list1: mylist[til firstlistlen];
   list2: firstlistlen _ mylist;
   a1: avg list1;
   a2: avg list2;
   out,: (a1 - a2) > diff;
 ];
 (sum out) % 1000}

/ find the significance of the difference in the averages
/ Returns average of first list; average of second list and the p value
/ of the difference being as great as it is.
findsignificance:{[list]
  i: list ? "_";
  list1: "F"$.z.x[til i];
  list2: "F"$(i+1) _ .z.x;
  a1: avg list1;
  a2: avg list2;
  if[a1 > a2;
 	pval: findpval[a1-a2; count list1; list1, list2];
  ];
  if[not a1 > a2;
 	pval: findpval[a2-a1; count list2; list2, list1];
  ];
  (avg list1; avg list2; pval)}
  


findsignificance[.z.x]


